import { Injectable } from '@angular/core';
import { AlertHelper } from '@helpers/alert.helper';
import { ConfirmationService } from 'primeng/api';

@Injectable({
  providedIn: 'root',
})
export class NetworkSpeedService {
    
    constructor(private _alert:AlertHelper,
        private confirmationService: ConfirmationService
    ) {
        
    }
  monitorNetwork(): void {
    if ('PerformanceObserver' in window) {
      const observer = new PerformanceObserver((list) => {
        list.getEntries().forEach((entry) => {
          if (entry.duration > 10000) {
            this.confirmationService.confirm({
                message: "اینترنت شما بسیار ضعیف شناسایی شده است ، این مسئله ممکن است باعث تجربه کاربری ناخوشایند شما شود ، لطفا در صورتی که وی پی ان شما وصل است آن را قطع کنید",
                header: "خطای شبکه",
                accept: () => {},
                key: 'warn',
              });
          }
        });
      });

      observer.observe({ entryTypes: ['resource'] });
    } else {
      console.warn('PerformanceObserver is not supported in this browser.');
    }
  }
}
