import {Injectable} from '@angular/core';
import {BehaviorSubject} from "rxjs";

@Injectable({
    providedIn: 'root'
})
export class PwaService {

    private deferredPrompt: any;
    public installPromptEvent: BehaviorSubject<any> = new BehaviorSubject(null);

    constructor() {
        window.addEventListener('beforeinstallprompt', (event) => {
            event.preventDefault();
            this.deferredPrompt = event;
            this.installPromptEvent.next(this.deferredPrompt);
        });
        window.addEventListener('appinstalled', () => this.installPromptEvent.next(null));
    }

    promptInstall(): void {
        if (this.deferredPrompt) {
            this.deferredPrompt.prompt();
            this.deferredPrompt.userChoice.then((choiceResult: any) => {
                if (choiceResult.outcome === 'accepted') {
                    console.log('User accepted the install prompt');
                } else {
                    console.log('User dismissed the install prompt');
                }
                this.deferredPrompt = null;
                this.installPromptEvent.next(null);
            });
        }
    }
}
