import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable, Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class AuthStore {
  public isActiveCaptcha = new Subject<any>();
  public isActiveCaptchaBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );
 
  public sendCodeToWhatsapp = new Subject<any>();
  public sendCodeToWhatsappBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );
 
  public sendCodeToTelegram = new Subject<any>();
  public sendCodeToTelegramBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public isActiveWhatsapp = new Subject<any>();
  public isActiveWhatsappBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public isActiveAuthenticationMobile = new Subject<any>();
  public isActiveAuthenticationMobileBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public isActiveSms = new Subject<any>();
  public isActiveSmsBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public isActiveAuthenticationEmail = new Subject<any>();
  public isActiveAuthenticationEmailBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public isActiveEmail = new Subject<any>();
  public isActiveEmailBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public isActiveTTS = new Subject<any>();
  public isActiveTTSBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public userNameBotTelegram = new Subject<any>();
  public userNameBotTelegramBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public showHelpLogin = new Subject<any>();
  public showHelpLoginBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public parallelSendingWhatsappLogin = new Subject<any>();
  public parallelSendingWhatsappLoginBehavior: BehaviorSubject<any> =
    new BehaviorSubject(null);

  public isActiveOAuth = new Subject<any>();
  public isActiveOAuthBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public parallelSendingTelegramLogin = new Subject<any>();
  public parallelSendingTelegramLoginBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public isActiveRecaptcha = new Subject<any>();
  public isActiveRecaptchahBehavior: BehaviorSubject<any> = new BehaviorSubject(
    null
  );

  public isActiveBotTelegram = new Subject<any>();
  public isActiveBotTelegramBehavior: BehaviorSubject<any> =
    new BehaviorSubject(null);

  getIsActiveCaptchaState(): Observable<any> {
    return this.isActiveCaptcha.asObservable();
  }
  getIsActiveCaptchaBehavior(): Observable<any> {
    return this.isActiveCaptchaBehavior.asObservable();
  }

  getIsActiveOAuthState(): Observable<any> {
    return this.isActiveOAuth.asObservable();
  }
  getIsActiveOAuthBehavior(): Observable<any> {
    return this.isActiveOAuthBehavior.asObservable();
  }

  getIsActiveRecaptcha(): Observable<any> {
    return this.isActiveCaptcha.asObservable();
  }
  getIsActiveRecaptchaBehavior(): Observable<any> {
    return this.isActiveCaptchaBehavior.asObservable();
  }
}
