import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable, Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class BlockStore {
  public blockOrder = new Subject<any>();
  public blockOrderBehavior: BehaviorSubject<any> = new BehaviorSubject(null);

  public expireOrder = new Subject<any>();
  public expireOrderBehavior: BehaviorSubject<any> = new BehaviorSubject(null);

  getIsBlockedState(): Observable<any> {
    return this.blockOrder.asObservable();
  }
  getIsBlockedStateBehavior(): Observable<any> {
    return this.blockOrderBehavior.asObservable();
  }

  getIsExpiredState(): Observable<any> {
    return this.expireOrder.asObservable();
  }
  getIsExpiredStateBehavior(): Observable<any> {
    return this.expireOrderBehavior.asObservable();
  }
}
