import { Injectable } from '@angular/core';
import { ICounts } from '@interfaces/user/ICounts';
import { BehaviorSubject, Observable, Subject } from "rxjs";

@Injectable({
  providedIn: 'root'
})
export class CountsStore {
  public count = new Subject<ICounts>();
  public countBehavior: BehaviorSubject<ICounts> = new BehaviorSubject(null);
  constructor() { }
  getCount(): Observable<ICounts> {
    return this.count.asObservable();
  }
  getCountBehavior(): Observable<ICounts> {
    return this.countBehavior.asObservable();
  }
}
