import { Injectable } from '@angular/core';
 
import { BehaviorSubject, Observable, Subject } from "rxjs";

@Injectable({
  providedIn: 'root'
})
export class DiscountCodeStore {
  public discountCode = new Subject<string>();
  public afterDiscount = new Subject<string>();
  public discount = new Subject<number>();
  

  constructor() { }

  getDiscount(): Observable<string> {
    return this.discountCode.asObservable();
  }
 
  getAfterDiscount(): Observable<string> {
    return this.afterDiscount.asObservable();
  }
 
  getDiscountValue():  Observable<number> {
    return this.discount.asObservable();
  }
 
}
