import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable, Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class LogingoutStore {
  public isLogout = new Subject<boolean>();
  public isLogoutBehavior: BehaviorSubject<boolean> = new BehaviorSubject(null);

  getLogoutState(): Observable<boolean> {
    return this.isLogout.asObservable();
  }
  getLogoutStateBehavior(): Observable<boolean> {
    return this.isLogoutBehavior.asObservable();
  }
}
