import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable, Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class MenuStateStore {
  public menu = new Subject<boolean>();
  public menuBehavior: BehaviorSubject<boolean> = new BehaviorSubject(null);
  constructor() {}
  getMenuState(): Observable<boolean> {
    return this.menu.asObservable();
  }
  getMenuStateBehavior(): Observable<boolean> {
    return this.menuBehavior.asObservable();
  }
}
