import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable, Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class SupportPhoneNumbersStore {
  public phoneNumbers = new Subject<boolean>();
  public phoneNumbersBehavior: BehaviorSubject<boolean> = new BehaviorSubject(null);
  constructor() {}
  getPhoneNumbersState(): Observable<boolean> {
    return this.phoneNumbers.asObservable();
  }
  getPhoneNumbersBehavior(): Observable<boolean> {
    return this.phoneNumbersBehavior.asObservable();
  }
}
