import { Injectable } from '@angular/core';
import { OrderSettingCheckout } from '@models/orders/orderSettingCheckoutModel';
import { BehaviorSubject, Observable, Subject } from "rxjs";

@Injectable({
  providedIn: 'root'
})

export class OrderSettingStore {
  public orderSetting  = new Subject<OrderSettingCheckout>();
  public orderSettingBehavior: BehaviorSubject<OrderSettingCheckout> = new BehaviorSubject(null);
  constructor() { }
  getOrderSetting(): Observable<OrderSettingCheckout> {
    return this.orderSetting.asObservable();
  }
  getOrderSettingBehavior(): Observable<OrderSettingCheckout> {
     return this.orderSettingBehavior.asObservable();
   }
}