import { Injectable } from '@angular/core';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { BehaviorSubject, Observable, Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class ScenarioStore {
  constructor() {}

  public scenario = new Subject<GetScenarioCheckout>();
  public scenarioBehavior: BehaviorSubject<GetScenarioCheckout> =
    new BehaviorSubject(null);

  public scenarios = new Subject<any>();
  public scenariosBehavior: BehaviorSubject<any> =
    new BehaviorSubject(null);

  getScenario(): Observable<GetScenarioCheckout> {
    return this.scenario.asObservable();
  }
  getScenarioBehavior(): Observable<GetScenarioCheckout> {
    return this.scenarioBehavior.asObservable();
  }

  getScenarios(): Observable<GetScenarioCheckout> {
    return this.scenarios.asObservable();
  }
  getScenariosBehavior(): Observable<GetScenarioCheckout> {
    return this.scenariosBehavior.asObservable();
  }
}
