import { Injectable } from '@angular/core';
import { UserProfile } from '@interfaces/user/userProfile';
import { VerifyingModel } from '@models/user/VerifyingModel';
import { BehaviorSubject, Observable, Subject } from 'rxjs';

@Injectable({
  providedIn: 'root',
})
export class UserStore {
  public user = new Subject<UserProfile>();
  public userBehavior: BehaviorSubject<UserProfile> = new BehaviorSubject(null);
  constructor() {}
  getUser(): Observable<UserProfile> {
    return this.user.asObservable();
  }
  getUserBehavior(): Observable<UserProfile> {
    return this.userBehavior.asObservable();
  }

  public userVerifying = new Subject<VerifyingModel[]>();
  public userVerifyingBehavior: BehaviorSubject<VerifyingModel[]> =
    new BehaviorSubject(null);
  getUserVerifying(): Observable<VerifyingModel[]> {
    return this.userVerifying.asObservable();
  }
  getUserVerifyingBehavior(): Observable<VerifyingModel[]> {
    return this.userVerifyingBehavior.asObservable();
  }
}
