import {CUSTOM_ELEMENTS_SCHEMA, NgModule, NO_ERRORS_SCHEMA, Optional, SkipSelf} from '@angular/core';
import { SharedModule } from '@shared/SharedModule';
import { PageErrorServerComponent } from './page-error-server/page-error-server.component';
import { PageNotAccessComponent } from './page-not-access/page-not-access.component';
import { PageNotFoundComponent } from './page-not-found/page-not-found.component';
import { ErrorsRoutingModule } from './errors.routes';
import { ErrorsComponent } from './errors.component';
import { PageErrorOfflineModeComponent } from './page-error-offline-mode/page-error-offline-mode.component';
import { BannedViaAdminComponent } from './banned-via-admin/banned-via-admin.component';
import { BannedViaIpComponent } from './banned-via-ip/banned-via-ip.component';

@NgModule({
  declarations: [
    ErrorsComponent,
    PageNotAccessComponent,
    PageNotFoundComponent,
    PageErrorServerComponent,
    PageErrorOfflineModeComponent,
    BannedViaIpComponent,
    BannedViaAdminComponent
  ],
  imports: [ErrorsRoutingModule, SharedModule],
  exports: [SharedModule],
  schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
})
export class ErrorsModule {
  constructor(
    @Optional()
    @SkipSelf()
    parentModule: ErrorsModule
  ) {
    if (parentModule) {
      throw new Error("ErrorsModule is already loaded.");
    }
  }
}
