import { NgModule } from '@angular/core';

import { RouterModule, Routes } from '@angular/router';
import { PageErrorServerComponent } from './page-error-server/page-error-server.component';
import { PageNotFoundComponent } from './page-not-found/page-not-found.component';
import { PageNotAccessComponent } from './page-not-access/page-not-access.component';
import { ErrorsComponent } from './errors.component';
import { PageErrorOfflineModeComponent } from './page-error-offline-mode/page-error-offline-mode.component';
import { BannedViaAdminComponent } from './banned-via-admin/banned-via-admin.component';
import { BannedViaIpComponent } from './banned-via-ip/banned-via-ip.component';
const routes: Routes = [
  {
    path: '',
    component: ErrorsComponent,
    children: [
      {
        path: 'not-found',
        component: PageNotFoundComponent,
        data: { title: 'صفحه ی مورد نظر یافت نشد' },
      },
      {
        path: 'server-error',
        component: PageErrorServerComponent,
        data: { title: 'یک نفر پاش رو سیمه!' },
      },
      {
        path: 'access-denied',
        component: PageNotAccessComponent,
        data: { title: 'شما به این صفحه دسترسی ندارید' },
      },
      {
        path: 'offline-mode',
        component: PageErrorOfflineModeComponent,
        data: { title: 'در دست تعمیر' },
      },
      {
        path: 'banned-mode-1',
        component: BannedViaAdminComponent,
        data: { title: 'شما مسدود شده اید' },
      },
      {
        path: 'banned-mode-2',
        component: BannedViaIpComponent,
        data: { title: 'آی پی شما مسدود شده است' },
      },
      { path: '', pathMatch: 'full', redirectTo: 'not-found' },
    ],
  },
];
@NgModule({
  imports: [[RouterModule.forChild(routes)]],
  exports: [RouterModule],
})
export class ErrorsRoutingModule {}
