import {
  AfterViewInit,
  Component,
  OnInit,
  ViewEncapsulation,
} from '@angular/core';
import { ErrorServices } from '@services/errors.service';

@Component({
  selector: 'page-not-found',
  templateUrl: 'page-not-found.component.html',
  styleUrls: ['./page-not-found.component.scss'],
  encapsulation: ViewEncapsulation.None,
  providers: [ErrorServices],
})
export class PageNotFoundComponent implements OnInit, AfterViewInit {
  constructor(private errorService: ErrorServices) {}
  ngAfterViewInit(): void {
    const previousPageUrl = sessionStorage.getItem('previousPageUrl');
    let error = {
      message: '404 - not-found-page',
      stack: previousPageUrl,
    };

    if (error.stack != window.location.href) {
      this.errorService.handleError(error);
    }
  }
  ngOnInit(): void {}
}
