import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  OnChanges,
  SimpleChanges,
} from '@angular/core';
import { Subscription } from 'rxjs';
import { ActivatedRoute, Router } from '@angular/router';
import { ScenarioStore } from '@stores/scenario.store';
import { isGuid } from '@helpers/validator.helper';
import { TranslateService } from '@ngx-translate/core';
import { ConfirmationService } from 'primeng/api';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { CheckoutsModel } from '@models/orders/checkoutsModel';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { OrderTypeStore } from '@stores/getOrderType.store';
import { OrderChangeStatusService } from '@services/orderChangeStatus.service';
import { PurchaseOrderModel } from 'src/app/core/params/order/PurchaseOrderModel';

@Component({
  selector: 'app-check-out',
  templateUrl: './checkout.component.html',
  styleUrls: ['./checkout.component.scss'],
})
export class CheckOutComponent
  implements OnInit, OnDestroy, AfterViewInit, OnChanges
{
  subscriptions = new Subscription();
  isLoadingGetOrder: boolean = false;
  maximumPrice: number;
  timeout = null;
  payType: string;
  dataCheckout: CheckoutsModel = new CheckoutsModel();
  isLoading: boolean = false;
  bankPort: any;
  allScenarios: any;
  bankId: string;
  discountCode: string;
  isDisabledWallet: boolean;
  isExpired: boolean;
  isValidRules: boolean = false;
  model: PurchaseOrderModel = new PurchaseOrderModel();
  checkoutActivations: PaymentMethodActivation = new PaymentMethodActivation();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  scenarioCheckoutModel: GetScenarioCheckout = new GetScenarioCheckout();

  constructor(
    private _activatedroute: ActivatedRoute,
    private _scenarioStore: ScenarioStore,
    private _router: Router,
    private confirmationService: ConfirmationService,
    private _translateService: TranslateService,
    public _discountCodeStore: DiscountCodeStore,
    public _orderTypeStore: OrderTypeStore,
    private _orderChangeStatusService: OrderChangeStatusService
  ) {
    this._discountCodeStore.discountCode.subscribe((res) => {
      this.discountCode = res;
    });
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.scenarioCheckoutModel = res;
      }
    });
    
    this._scenarioStore.getScenariosBehavior().subscribe((res) => {
      if (res != null) {
        this.allScenarios = res;
      }
    });;
    this._orderTypeStore.orderType.subscribe((res) => {
      this.dataCheckout.orderType = res;
    });
  }
  ngOnChanges(changes: SimpleChanges): void {
    throw new Error('Method not implemented.');
  }

  ngOnInit(): void {
    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl('/dashboard/orders');
    this.model.orderId = this._activatedroute.snapshot.params['id'];
  }

  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
  getIsDisabledWallet(value: boolean) {
    this.isDisabledWallet = value;
  }

  confirmFreeOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'freeOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'freeOrderPayment'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmFreeOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  confirmStatusWaitingOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'waitingOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'orderAccept'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmWaitingOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  settingCheckoutGet(data: GetSettingCheckout) {
    if (data) {
      this.settingCheckoutModel = data;
      this.checkoutActivations = this.settingCheckoutModel;
      this.maximumPrice = this.settingCheckoutModel.maximumAmountOnlinePort;
    }
  }

  submit() {
    if (Number(this.payType) == 429) {
      this.updateStatusWaiting();
    }
  }

  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
  }

  updateFreeOrder() {
    this._orderChangeStatusService.updateFreeOrder(
      this.subscriptions,
      this.model.orderId,
      this.discountCode,
      this.confirmFreeOrder.bind(this),
      (loading: boolean) => {
        this.isLoading = loading;
      }
    );
  }

  updateStatusWaiting() {
    this._orderChangeStatusService.updateStatusWaiting(
      this.model.orderId,
      this.subscriptions,
      this.confirmStatusWaitingOrder.bind(this),
      (loading: boolean) => {
        this.isLoading = loading;
      }
    );
  }
}
