import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  OnChanges,
  SimpleChanges,
  ChangeDetectorRef,
} from '@angular/core';
import { UserProfile } from '@interfaces/user/userProfile';
import { Subscription } from 'rxjs';
import { ActivatedRoute, Router } from '@angular/router';
import { ScenarioStore } from '@stores/scenario.store';
import { SellingPerfectMoneyGetModel } from '@models/orders/sellingPerfectMoneyGetModel';
import { isGuid } from '@helpers/validator.helper';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { OrderTypeStore } from '@stores/getOrderType.store';
import { TranslateService } from '@ngx-translate/core';
import { ConfirmationService } from 'primeng/api';
import { OrderChangeStatusService } from '@services/orderChangeStatus.service';
import { PurchaseOrderModel } from 'src/app/core/params/order/PurchaseOrderModel';

@Component({
  selector: 'app-check-out',
  templateUrl: './checkout.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckOutComponent
  implements OnInit, OnDestroy, AfterViewInit, OnChanges
{
  subscriptions = new Subscription();
  data: UserProfile;
  timeout = null;
  payType: string = null;
  dataCheckout: SellingPerfectMoneyGetModel = new SellingPerfectMoneyGetModel();
  isLoading: boolean = false;
  bankPort: any;
  allScenarios: any;
  discountCode: string;
  isExpired: boolean;
  isValidRules: boolean = false;
  checkoutActivations: PaymentMethodActivation = new PaymentMethodActivation();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  scenarioCheckoutModel: GetScenarioCheckout = new GetScenarioCheckout();
  orderType: string;
  model: PurchaseOrderModel = new PurchaseOrderModel();
  constructor(
    private _activatedroute: ActivatedRoute,
    private cdr: ChangeDetectorRef,
    private _scenarioStore: ScenarioStore,
    private _router: Router,
    public _discountCodeStore: DiscountCodeStore,
    private _orderTypeStore: OrderTypeStore,
    private confirmationService: ConfirmationService,
    private _translateService: TranslateService,
    private _orderChangeStatusService: OrderChangeStatusService
  ) {
    this._discountCodeStore.discountCode.subscribe((res) => {
      this.discountCode = res;
    });
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.scenarioCheckoutModel = res;
      }
    });

    this._scenarioStore.getScenariosBehavior().subscribe((res) => {
      if (res != null) {
        this.allScenarios = res;
      }
    });
  }

  ngOnChanges(changes: SimpleChanges): void {
    throw new Error('Method not implemented.');
  }

  ngOnInit(): void {
    this._orderTypeStore.getOrderType().subscribe((res) => {
      if (res) {
        this.orderType = res;
      }
    });
    this._orderTypeStore.getOrderTypeBehavior().subscribe((res) => {
      if (res) {
        this.orderType = res;
      }
    });

    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl('/dashboard/orders');
    this.model.orderId = this._activatedroute.snapshot.params['id'];
  }

  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  confirmStatusWaitingOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'waitingOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'orderAccept'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmWaitingOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
    this.cdr.detectChanges();
  }

  settingCheckoutGet(data: GetSettingCheckout) {
    if (data) {
      this.settingCheckoutModel = data;
      this.checkoutActivations = this.settingCheckoutModel;
      this.cdr.detectChanges();
    }
  }

  updateStatusWaiting() {
    this._orderChangeStatusService.updateStatusWaiting(
      this.model.orderId,
      this.subscriptions,
      this.confirmStatusWaitingOrder.bind(this),
      (loading: boolean) => {
        this.isLoading = loading;
        this.cdr.detectChanges();
      }
    );
  }

  updateStatusDocument() {
    this._orderChangeStatusService.updateStatusDocument(
      this.orderType,
      this.model.orderId,
      this.discountCode,
      this.payType,
      (url) => {
        this._router.navigateByUrl(url);
      },
      (isLoading) => {
        this.isLoading = isLoading;
        this.cdr.detectChanges();
      }
    );
  }
}
