import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  OnChanges,
  SimpleChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { ActivatedRoute, Router } from '@angular/router';
import { ScenarioStore } from '@stores/scenario.store';
import { SellingPerfectMoneyGetModel } from '@models/orders/sellingPerfectMoneyGetModel';
import { isGuid } from '@helpers/validator.helper';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { TranslateService } from '@ngx-translate/core';
import { ConfirmationService } from 'primeng/api';
import { OrderChangeStatusService } from '@services/orderChangeStatus.service';
import { PurchaseOrderModel } from 'src/app/core/params/order/PurchaseOrderModel';
@Component({
  selector: 'app-check-out',
  templateUrl: './checkout.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckOutComponent implements OnInit, OnDestroy, OnChanges {
  subscriptions = new Subscription();
  data: UserProfile;
  timeout = null;
  payType: string = null;
  dataCheckout: SellingPerfectMoneyGetModel = new SellingPerfectMoneyGetModel();
  isLoading: boolean = false;
  bankPort: any;
  allScenarios: any;
  discountCode: string;
  isLoadingGetCheckoutSetting: boolean;
  isExpired: boolean;
  isValidRules: boolean = false;
  model: PurchaseOrderModel = new PurchaseOrderModel();
  checkoutActivations: PaymentMethodActivation = new PaymentMethodActivation();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  scenarioCheckoutModel: GetScenarioCheckout = new GetScenarioCheckout();
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _activatedroute: ActivatedRoute,
    private _scenarioStore: ScenarioStore,
    private _router: Router,
    public _discountCodeStore: DiscountCodeStore,
    private confirmationService: ConfirmationService,
    private _translateService: TranslateService,
    private _orderChangeStatusService: OrderChangeStatusService,
  ) {
    this._discountCodeStore.discountCode.subscribe((res) => {
      this.discountCode = res;
    });
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.scenarioCheckoutModel = res;
      }
    });
    
    this._scenarioStore.getScenariosBehavior().subscribe((res) => {
      if (res != null) {
        this.allScenarios = res;
      }
    });;
  }
  ngOnChanges(changes: SimpleChanges): void {
    throw new Error('Method not implemented.');
  }

  ngOnInit() {
    this.model.orderId = this._activatedroute.snapshot.params['id'];

    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl('/dashboard/orders');
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  settingCheckoutGet(data: GetSettingCheckout) {
    if (data) {
      this.settingCheckoutModel = data;
      this.checkoutActivations = this.settingCheckoutModel;
    }
  }

  submit() {
    if (Number(this.payType) == 428) {
      this.updatePMSellingStatus();
    } else if (Number(this.payType) == 429) {
      this.updateStatusWaiting();
    }
  }

  updatePMSellingStatus() {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.PerfectMoneySellUpdateStatus,
          { orderId: this.model.orderId },
          false
        )
        .pipe(finalize(() => {}))
        .subscribe(
          (response: response) => {
            window.location.href = response.data.urlRedirect;
            this.cdr.detectChanges();
          },
          (error) => {
            this.isLoading = false;
            this.cdr.detectChanges();
          }
        )
    );
  }

  confirmStatusWaitingOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'waitingOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'orderAccept'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmWaitingOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
  }

  updateStatusDocument() {
  this._orderChangeStatusService.updateStatusDocument(
    '165',
    this.model.orderId,
    this.discountCode,
    this.payType,
    (url) => {
      this._router.navigateByUrl(url);
    },
    (isLoading) => {
      this.isLoading = isLoading;
      this.cdr.detectChanges();
    }
  );
}


  updateStatusWaiting() {
    this._orderChangeStatusService.updateStatusWaiting(
      this.model.orderId,
      this.subscriptions,
      this.confirmStatusWaitingOrder.bind(this),
      (loading: boolean) => {
        this.isLoading = loading;
        this.cdr.detectChanges();
      }
    );
  }
}
