import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  ViewChild,
  OnChanges,
  SimpleChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { ActivatedRoute, Router } from '@angular/router';
import { ScenarioStore } from '@stores/scenario.store';
import { CheckoutsModel } from '@models/orders/checkoutsModel';
import { isGuid } from '@helpers/validator.helper';
import { ConfirmationService } from 'primeng/api';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { TutorialModalComponent } from 'src/app/modules/components/tutorialModal/tutorialModal.component';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { TranslateService } from '@ngx-translate/core';
import { OrderChangeStatusService } from '@services/orderChangeStatus.service';
import { PurchaseOrderModel } from 'src/app/core/params/order/PurchaseOrderModel';

@Component({
  selector: 'app-check-out',
  templateUrl: './checkout.component.html',
  styleUrls: ['./checkout.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckOutComponent implements OnInit, OnDestroy, OnChanges {
  @ViewChild('tutorial') tutorial: TutorialModalComponent;
  subscriptions = new Subscription();
  data: UserProfile;
  timeout = null;
  payType: string = null;
  dataCheckout: CheckoutsModel = new CheckoutsModel();
  maximumPrice: number;
  bankPort: any;
  allScenarios: any;
  isLoading: boolean = false;
  discountCode: string;
  isExpired: boolean;
  isValidRules: boolean = false;
  model: PurchaseOrderModel = new PurchaseOrderModel();
  checkoutActivations: PaymentMethodActivation = new PaymentMethodActivation();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  scenarioCheckoutModel: GetScenarioCheckout = new GetScenarioCheckout();

  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _activatedroute: ActivatedRoute,
    private _scenarioStore: ScenarioStore,
    private confirmationService: ConfirmationService,
    private _router: Router,
    public _discountCodeStore: DiscountCodeStore,
    private _translateService: TranslateService,
    private _orderChangeStatusService: OrderChangeStatusService
  ) {
    this._discountCodeStore.discountCode.subscribe((res) => {
      this.discountCode = res;
    });
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.scenarioCheckoutModel = res;
      }
    });
    
    this._scenarioStore.getScenariosBehavior().subscribe((res) => {
      if (res != null) {
        this.allScenarios = res;
      }
    });;
  }

  ngOnChanges(changes: SimpleChanges): void {
    throw new Error('Method not implemented.');
  }

  ngOnInit(): void {
    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl('/dashboard/orders');
    this.model.orderId = this._activatedroute.snapshot.params['id'];
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  settingCheckoutGet(data: GetSettingCheckout) {
    if (data) {
      this.settingCheckoutModel = data;
      this.checkoutActivations = this.settingCheckoutModel;
    }
  }

  confirm() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'successfulTransferVoucherPerfectMoney'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'successfulTransfer'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToCustomerPanel'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  submit() {
    if (Number(this.payType) == 428) {
      this.updatePMVoucherStatus();
    } else if (Number(this.payType) == 429) {
      this.updateStatusWaiting();
    }
  }

  confirmStatusWaitingOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'waitingOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'orderAccept'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmWaitingOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  updatePMVoucherStatus() {
    this.isLoading = true;
    this.subscriptions.add(
      this._commonService
        .put(
          Address.VoucherPerfectMoneySellUpdateStatus,
          { orderId: this.model.orderId },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoading = false;
          })
        )
        .subscribe((res) => {
          this.confirm();
        })
    );
  }

  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
  }

  updateStatusWaiting() {
    this._orderChangeStatusService.updateStatusWaiting(
      this.model.orderId,
      this.subscriptions,
      this.confirmStatusWaitingOrder.bind(this),
      (loading: boolean) => {
        this.isLoading = loading;
        this.cdr.detectChanges();
      }
    );
  }
}
