import {
  Component,
  OnDestroy,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  OnChanges,
  SimpleChanges,
} from '@angular/core';
import { UserProfile } from '@interfaces/user/userProfile';
import { Subscription } from 'rxjs';
import { ActivatedRoute, Router } from '@angular/router';
import { ScenarioStore } from '@stores/scenario.store';
import { CheckoutsModel } from '@models/orders/checkoutsModel';
import { isGuid } from '@helpers/validator.helper';
import { TranslateService } from '@ngx-translate/core';
import { ConfirmationService } from 'primeng/api';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { PaymentMethodActivation } from '@models/orders/paymentMethodsActivationModel';
import { GetSettingCheckout } from '@models/orders/getSetngCheckoutModel';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';
import { OrderChangeStatusService } from '@services/orderChangeStatus.service';
import { PurchaseOrderModel } from 'src/app/core/params/order/PurchaseOrderModel';

@Component({
  selector: 'app-check-out',
  templateUrl: './checkout.component.html',
  styleUrls: ['./checkout.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckOutComponent implements OnInit, OnDestroy, OnChanges {
  subscriptions = new Subscription();
  maximumPrice: number;
  data: UserProfile;
  timeout = null;
  payType: string;
  dataCheckout: CheckoutsModel = new CheckoutsModel();
  isLoading: boolean = false;
  bankPort: any;
  checkedRole: boolean = false;
  allScenarios: any;
  bankId: string;
  discountCode: string;
  isDisabledWallet: boolean;
  isExpired: boolean;
  isValidRules: boolean = false;
  model: PurchaseOrderModel = new PurchaseOrderModel();
  checkoutActivations: PaymentMethodActivation = new PaymentMethodActivation();
  settingCheckoutModel: GetSettingCheckout = new GetSettingCheckout();
  scenarioCheckoutModel: GetScenarioCheckout = new GetScenarioCheckout();

  constructor(
    private cdr: ChangeDetectorRef,
    private _activatedroute: ActivatedRoute,
    private _scenarioStore: ScenarioStore,
    private _router: Router,
    public _discountCodeStore: DiscountCodeStore,
    private confirmationService: ConfirmationService,
    private _translateService: TranslateService,
    private _orderChangeStatusService: OrderChangeStatusService
  ) {
    this._discountCodeStore.discountCode.subscribe((res) => {
      this.discountCode = res;
    });
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.scenarioCheckoutModel = res;
      }
    });

    this._scenarioStore.getScenariosBehavior().subscribe((res) => {
      if (res != null) {
        this.allScenarios = res;
      }
    });
  }

  ngOnChanges(changes: SimpleChanges): void {
    throw new Error('Method not implemented.');
  }

  ngOnInit(): void {
    if (!isGuid(this._activatedroute.snapshot.params['id']))
      this._router.navigateByUrl('/dashboard/orders');
    this.model.orderId = this._activatedroute.snapshot.params['id'];

    
  }

  confirmAfterSetAppointment() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'appointmentMsg'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'appointmentHeader'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'setAppointment',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getIsDisabledWallet(value: boolean) {
    this.isDisabledWallet = value;
  }

  settingCheckoutGet(data: GetSettingCheckout) {
    if (data) {
      this.settingCheckoutModel = data;
      this.checkoutActivations = this.settingCheckoutModel;
      this.maximumPrice = this.settingCheckoutModel.maximumAmountOnlinePort;
    }
  }

  refreshConfirm() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'refreshPageMessage'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'checkVpnConnection'
        ],
      key: 'refreshPage',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'refreshPage'
        ],
      rejectVisible: false,
      acceptIcon: 'none',
      accept: () => {
        location.reload();
      },
    });
  }

  confirmFreeOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'freeOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'freeOrderPayment'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmFreeOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  confirmStatusWaitingOrder() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'waitingOrderAlarm'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'orderAccept'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'alarmWaitingOrder',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        this._router.navigateByUrl('/dashboard/orders/invoices');
      },
    });
  }

  payByWalletConfirm() {
    this.confirmationService.confirm({
      message:
        this._translateService.translations[this._translateService.currentLang][
          'payByWalletAlert'
        ],
      header:
        this._translateService.translations[this._translateService.currentLang][
          'orderCompletion'
        ],
      icon: 'pi pi-check-circle',
      rejectVisible: false,
      key: 'payByWallet',
      acceptLabel:
        this._translateService.translations[this._translateService.currentLang][
          'backToOrderList'
        ],
      acceptIcon: 'none',
      accept: () => {
        window.location.href = '/dashboard/orders/invoices';
      },
    });
  }

  recieveFinishCountDown($event: boolean) {
    this.isExpired = $event;
  }

  purchaseByWallet() {
    this._orderChangeStatusService.purchaseByWallet(
      this.subscriptions,
      this.model.orderId,
      this.discountCode,
      this.confirmFreeOrder.bind(this),
      this.payByWalletConfirm.bind(this),
      (loading: boolean) => {
        this.isLoading = loading;
        this.cdr.detectChanges();
      }
    );
  }

  UpdateStatusSetAppointment() {
    this._orderChangeStatusService.updateStatusSetAppointment(
      this.subscriptions,
      this.model.orderId,
      this.confirmFreeOrder.bind(this),
      this.confirmAfterSetAppointment.bind(this),
      (loading: boolean) => {
        this.isLoading = loading;
        this.cdr.detectChanges();
      }
    );
  }

  cryptoPayment() {
    this._orderChangeStatusService.cryptoPayment(
      this.model.orderId,
      (url) => this._router.navigateByUrl(url),
      (val) => {
        this.isLoading = val;
        this.cdr.detectChanges();
      }
    );
  }

  purchase() {
    this._orderChangeStatusService.purchase(
      this.subscriptions,
      this.model,
      this.allScenarios,
      this.bankPort,
      this.bankId,
      this.settingCheckoutModel.checkBankAccount,
      this.discountCode,
      () => this.confirmFreeOrder(),
      () => this.refreshConfirm(),
      (loading: boolean) => {
        this.isLoading = loading;
      },
      () => {
        this.cdr.detectChanges();
      }
    );
  }

  updateFreeOrder() {
    this._orderChangeStatusService.updateFreeOrder(
      this.subscriptions,
      this.model.orderId,
      this.discountCode,
      this.confirmFreeOrder.bind(this),
      (loading: boolean) => {
        this.isLoading = loading;
        this.cdr.detectChanges();
      }
    );
  }

  updateStatusDocument() {
    this._orderChangeStatusService.updateStatusDocument(
      this.dataCheckout.orderType,
      this.model.orderId,
      this.discountCode,
      this.payType,
      (url) => {
        this._router.navigateByUrl(url);
      },
      (isLoading) => {
        this.isLoading = isLoading;
        this.cdr.detectChanges();
      }
    );
  }

  docStatusPayType() {
    this.payType = '431';
    this.updateStatusDocument();
  }

  updateStatusWaiting() {
    this._orderChangeStatusService.updateStatusWaiting(
      this.model.orderId,
      this.subscriptions,
      this.confirmStatusWaitingOrder.bind(this),
      (loading: boolean) => {
        this.isLoading = loading;
        this.cdr.detectChanges();
      }
    );
  }
}
