import { Component, OnDestroy, ChangeDetectionStrategy } from '@angular/core';
import { CheckoutActivationsStore } from '@stores/getIsAcceptedAppFee';

import { Subscription } from 'rxjs';
@Component({
  selector: 'checkouts',
  templateUrl: './checkouts.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CheckoutsComponent implements OnDestroy {
  subscriptions = new Subscription();

  constructor(public _checkoutActivations: CheckoutActivationsStore) {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
