import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { CheckoutsComponent } from './checkouts.components';
const routes: Routes = [
  {
    path: '',
    component: CheckoutsComponent,
    children: [
      { path: '', redirectTo: 'invoices', pathMatch: 'prefix' },
      {
        path: 'swift/:id',
        loadChildren: () =>
          import(
            './checkout-swift/checkout-swiftTransfer/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'swift/:id/:language',
        loadChildren: () =>
          import(
            './checkout-swift/checkout-swiftTransfer/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'fee/:id',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-application-fee/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'fee/:id/:language',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-application-fee/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'freeorder/:id',
        loadChildren: () =>
          import('./checkout-freeOrder/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'freeorder/:id/:language',
        loadChildren: () =>
          import('./checkout-freeOrder/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'dormitory-fee/:id',
        loadChildren: () =>
          import('./checkout-fee/checkout-dormitoryFee/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'dormitory-fee/:id/:language',
        loadChildren: () =>
          import('./checkout-fee/checkout-dormitoryFee/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },

      {
        path: 'paypal-recharge/:id',
        loadChildren: () =>
          import('./checkout-paypal/paypal-recharge/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'paypal-recharge/:id/:language',
        loadChildren: () =>
          import('./checkout-paypal/paypal-recharge/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },

      {
        path: 'paypal-sell/:id',
        loadChildren: () =>
          import('./checkout-paypal/paypal-sell/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'paypal-sell/:id/:language',
        loadChildren: () =>
          import('./checkout-paypal/paypal-sell/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },

      {
        path: 'incomecash/:id',
        loadChildren: () =>
          import('./checkout-fee/checkout-incomeCash/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'incomecash/:id/:language',
        loadChildren: () =>
          import('./checkout-fee/checkout-incomeCash/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },

      {
        path: 'accountRecharge/:id',
        loadChildren: () =>
          import('./checkout-freeOrder/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'accountRecharge/:id/:language',
        loadChildren: () =>
          import('./checkout-freeOrder/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },

      {
        path: 'university-tuition/:id',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-universityTuition/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'university-tuition/:id/:language',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-universityTuition/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'voucherperfectmoneybuy/:id',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-voucherPerfectMoney/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'voucherperfectmoneybuy/:id/:language',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-voucherPerfectMoney/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'voucherperfectmoneysell/:id',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-voucherPerfectMoneySell/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'voucherperfectmoneysell/:id/:language',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-voucherPerfectMoneySell/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'perfectmoneybuying/:id',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-perfectMoneyBuying/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'perfectmoneybuying/:id/:language',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-perfectMoneyBuying/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'sellingperfectmoney/:id',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-sellingPerfectMoney/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'sellingperfectmoney/:id/:language',
        loadChildren: () =>
          import(
            './checkout-perfectMoney/checkout-sellingPerfectMoney/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'remittancetoIran/:id',
        loadChildren: () =>
          import(
            './checkout-swift/checkout-sendRemittanceToIran/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'remittancetoIran/:id/:language',
        loadChildren: () =>
          import(
            './checkout-swift/checkout-sendRemittanceToIran/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'payeeraccountrecharge/:id',
        loadChildren: () =>
          import(
            './checkout-payeer/checkout-payeerAccountRecharge/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'payeeraccountrecharge/:id/:language',
        loadChildren: () =>
          import(
            './checkout-payeer/checkout-payeerAccountRecharge/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'sellingpayeer/:id',
        loadChildren: () =>
          import(
            './checkout-payeer/checkout-payeerSelling/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'sellingpayeer/:id/:language',
        loadChildren: () =>
          import(
            './checkout-payeer/checkout-payeerSelling/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'wiseaccountcharge/:id',
        loadChildren: () =>
          import(
            './checkout-wise/checkout-wiseAccountCharge/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'wiseaccountcharge/:id/:language',
        loadChildren: () =>
          import(
            './checkout-wise/checkout-wiseAccountCharge/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'sellingwise/:id',
        loadChildren: () =>
          import('./checkout-wise/checkout-sellingWise/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'sellingwise/:id/:language',
        loadChildren: () =>
          import('./checkout-wise/checkout-sellingWise/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },

      {
        path: 'premium-accounts/:id',
        loadChildren: () =>
          import('./checkout-premium/checkout-premium/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'premium-accounts/:id/:language',
        loadChildren: () =>
          import('./checkout-premium/checkout-premium/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },

      {
        path: 'giftcard/:id',
        loadChildren: () =>
          import('./checkout-giftCards/checkout-giftCard/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'giftcard/:id/:language',
        loadChildren: () =>
          import('./checkout-giftCards/checkout-giftCard/checkout.module').then(
            (m) => m.CheckOutModule
          ),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'internationalpayment/:id',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-paymentInternationalSites/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'internationalpayment/:id/:language',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-paymentInternationalSites/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'internationalpaymentb/:id',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-paymentInternationalSites-planB/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'internationalpaymentb/:id/:language',
        loadChildren: () =>
          import(
            './checkout-fee/checkout-paymentInternationalSites-planB/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'virtualServers/:id',
        loadChildren: () =>
          import(
            './checkout-virtualServers/checkout-virtualServers/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },
      {
        path: 'virtualServers/:id/:language',
        loadChildren: () =>
          import(
            './checkout-virtualServers/checkout-virtualServers/checkout.module'
          ).then((m) => m.CheckOutModule),
        data: {
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class CheckoutsRoutingModule {}
