import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  OnChanges,
  OnInit,
  Output,
  SimpleChanges,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { DeviceDetectorService } from 'ngx-device-detector';
import { finalize, Subscription } from 'rxjs';
import { cloneDeep } from 'lodash-es';
import { DomSanitizer } from '@angular/platform-browser';

@Component({
  selector: 'acceptRoles',
  templateUrl: 'acceptRoles.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AcceptRolesComponent implements OnInit, OnChanges {
  @Input() payTypes: string;
  @Input() isValidRules: boolean;
  @Input() paymentMethodList: any[] = [];
  @Input() dataCheckout: any = null;
  @Input() checkedRole: boolean = false;
  @Output() checkedRoleChange: EventEmitter<boolean> =
    new EventEmitter<boolean>();

  isLoadingGet: boolean = true;
  subscriptions = new Subscription();
  visibleRoles: boolean = false;
  isDesktop: boolean;
  termsConditions: any;
  termsConditionsHtml: any;

  constructor(
    private cdr: ChangeDetectorRef,
    private _commonService: CommonService,
    public _deviceDetectorService: DeviceDetectorService,
    private sanitizer: DomSanitizer
  ) {}

  ngOnInit() {
    this.getTermsConditionsContent();
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this.cdr.detectChanges();
  }

  ngOnChanges(changes: SimpleChanges) {
    if (
      changes['checkedRole'] &&
      changes['checkedRole'].currentValue === true
    ) {
      this.checkedRole = true;
    }
  }

  getChanges(e: any) {
    this.checkedRoleChange.emit(this.checkedRole);
    this.cdr.detectChanges();
  }

  getTermsConditionsContent(): void {
    this.subscriptions.add(
      this._commonService
        .put(Address.TermsConditionsGet, {})
        .pipe(finalize(() => {}))
        .subscribe((res) => {
          if (res && res.data) {
            this.termsConditions = cloneDeep(res.data);
            for (let item in this.termsConditions) {
              this.termsConditionsHtml = this.sanitizer.bypassSecurityTrustHtml(
                this.termsConditions[item]
              );
            }
          }
        })
    );
  }
}
