import { VerifyingModel } from '@models/user/VerifyingModel';
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  OnChanges,
  OnDestroy,
  Output,
  ViewChild,
} from '@angular/core';
import { finalize, Subscription } from 'rxjs';
import { CommonService } from '@services/common.service';
import { response } from '@interfaces/response';
import { Address } from '@enums/address.enum';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { Router } from '@angular/router';
import { OrderVerifyComponent } from '../modalContentMobile/orderVerify/orderVerify.component';

@Component({
  selector: 'alarm-order',
  templateUrl: './alarmOrder.component.html',
  styleUrls: ['./alarmOrder.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class AlarmOrderComponent implements OnChanges, OnDestroy {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef
  ) {}
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  dataVerifying: VerifyingModel[] = [];
  subscriptions = new Subscription();
  noExistsBankCard: boolean = true;
  isAcceptBankCard: boolean = false;
  noExistsPhone: boolean = true;
  isAcceptPhone: boolean = false;
  noExistsCard: boolean = true;
  isAcceptCard: boolean = false;
  noExistsMobile: boolean = true;
  isAcceptMobile: boolean = false;
  noExistsEmail: boolean = true;
  isAcceptEmail: boolean = false;
  noExistsSelfie: boolean = true;
  isAcceptSelfie: boolean = false;
  noExistsInfo: boolean = true;
  isAcceptInfo: boolean = false;
  isVerified: boolean = false;
  isLoadingVeifty: boolean = true;
  isLoadingGetBankAccount: boolean;
  lockUserVerifying: number = 0;
  isLoading: boolean = true;
  @Input() checkOrderSetting: IExistVerifying;
  @Input() orderType: any;
  @Input() notificationBeforeSave: string = null;
  @Input() errMsg: string = null;
  @Output() notificationBeforeSaveChange: EventEmitter<string> =
    new EventEmitter<string>();
  @Output() isVerifiedInfo = new EventEmitter<boolean>();
  @Input() notificationBeforeSaveType: string = null;
  @Output() notificationBeforeSaveTypeChange: EventEmitter<string> =
    new EventEmitter<string>();

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  ngOnChanges() {
    if (
      this.checkOrderSetting &&
      this.checkOrderSetting.orderType &&
      this.lockUserVerifying < 1
    ) {
      this.orderSetting();
    }
  }

  hideAlarmOrder() {
    this.isVerified = true;
    this.cdr.detectChanges();
  }

  userGetVerifying() {
    this.isLoadingVeifty = true;
    this.lockUserVerifying = this.lockUserVerifying + 1;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.UserVerifying, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingVeifty = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataVerifying = response.data;

            for (let item of this.dataVerifying) {
              if (
                item.typeVerifying == 115 &&
                this.checkOrderSetting.checkBankAccount
              ) {
                this.noExistsBankCard = false;
                this.isAcceptBankCard = item.isAccept;
              }

              if (
                item.typeVerifying == 112 &&
                this.checkOrderSetting.checkEmail
              ) {
                this.noExistsEmail = false;
                this.isAcceptEmail = item.isAccept;
              }

              if (
                item.typeVerifying == 111 &&
                this.checkOrderSetting.checkMobile
              ) {
                this.noExistsMobile = false;
                this.isAcceptMobile = item.isAccept;
              }

              if (
                item.typeVerifying == 113 &&
                this.checkOrderSetting.checkPhone
              ) {
                this.noExistsPhone = false;
                this.isAcceptPhone = item.isAccept;
              }

              if (
                item.typeVerifying == 114 &&
                this.checkOrderSetting.checkNationalCard
              ) {
                this.noExistsCard = false;
                this.isAcceptCard = item.isAccept;
              }

              if (
                item.typeVerifying == 118 &&
                this.checkOrderSetting.checkBasicInformation
              ) {
                this.noExistsInfo = false;
                this.isAcceptInfo = item.isAccept;
              }

              if (
                item.typeVerifying == 116 &&
                this.checkOrderSetting.checkSelfiImage
              ) {
                this.noExistsSelfie = false;
                this.isAcceptSelfie = item.isAccept;
              }

              if (!this.checkOrderSetting.checkBankAccount) {
                this.noExistsBankCard = false;
                this.isAcceptBankCard = true;
              }
              if (!this.checkOrderSetting.checkEmail) {
                this.noExistsEmail = false;
                this.isAcceptEmail = true;
              }
              if (!this.checkOrderSetting.checkNationalCard) {
                this.noExistsCard = false;
                this.isAcceptCard = true;
              }
              if (!this.checkOrderSetting.checkMobile) {
                this.noExistsMobile = false;
                this.isAcceptMobile = true;
              }

              if (!this.checkOrderSetting.checkBasicInformation) {
                this.noExistsInfo = false;
                this.isAcceptInfo = true;
              }
              if (!this.checkOrderSetting.checkPhone) {
                this.noExistsPhone = false;
                this.isAcceptPhone = true;
              }

              if (!this.checkOrderSetting.checkSelfiImage) {
                this.noExistsSelfie = false;
                this.isAcceptSelfie = true;
              }
              this.cdr.detectChanges();
            }

            if (
              this.isAcceptBankCard &&
              this.isAcceptEmail &&
              this.isAcceptCard &&
              this.isAcceptInfo &&
              this.isAcceptMobile &&
              this.isAcceptPhone &&
              this.isAcceptSelfie &&
              !(
                this.noExistsEmail &&
                this.noExistsBankCard &&
                this.noExistsCard &&
                this.noExistsInfo &&
                this.noExistsMobile &&
                this.noExistsPhone &&
                this.noExistsSelfie
              )
            ) {
            } else {
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  orderSetting() {
    this.isLoading = false;
    if (
      this.checkOrderSetting &&
      this.checkOrderSetting.notificationListBeforeSave
    ) {
      this.notificationBeforeSaveChange.emit(
        this.checkOrderSetting.notificationListBeforeSave
      );
    }
    if (
      this.checkOrderSetting &&
      this.checkOrderSetting.notificationListBeforeSaveType
    ) {
      this.notificationBeforeSaveTypeChange.emit(
        this.checkOrderSetting.notificationListBeforeSaveType
      );
    }

    if (
      (this.checkOrderSetting.checkBankAccount &&
        !this.checkOrderSetting.minAmountCheckBankAccount) ||
      (this.checkOrderSetting.checkBasicInformation &&
        !this.checkOrderSetting.minAmountCheckBasicInformation) ||
      (this.checkOrderSetting.checkEmail &&
        !this.checkOrderSetting.minAmountCheckEmail) ||
      (this.checkOrderSetting.checkMobile &&
        !this.checkOrderSetting.minAmountCheckMobile) ||
      (this.checkOrderSetting.checkNationalCard &&
        !this.checkOrderSetting.minAmountCheckNationalCard) ||
      (this.checkOrderSetting.checkPhone &&
        !this.checkOrderSetting.minAmountCheckPhone) ||
      this.checkOrderSetting.checkSelfiImage
    ) {
      this.userGetVerifying();

      this.cdr.detectChanges();
    } else {
      this.noExistsBankCard = false;
      this.isAcceptBankCard = true;

      this.noExistsEmail = false;
      this.isAcceptEmail = true;

      this.noExistsCard = false;
      this.isAcceptCard = true;

      this.noExistsInfo = false;
      this.isAcceptInfo = true;

      this.noExistsMobile = false;
      this.isAcceptMobile = true;

      this.noExistsPhone = false;
      this.isAcceptPhone = true;

      this.noExistsSelfie = false;
      this.isAcceptSelfie = true;
    }

    this.cdr.detectChanges();
  }

  openAddInformationModal() {
    setTimeout(() => {
      this.orderVerify.modalGetMobile();
    }, 200);
  }
}
