import {
  Component,
  OnInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  OnDestroy,
  Output,
  EventEmitter,
  Input,
} from '@angular/core';
import { Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';

import { BlockStore } from '@stores/blockOrder';

import { Subscription } from 'rxjs';

@Component({
  selector: 'block-access-order',
  templateUrl: 'blockAccessOrder.component.html',
  styleUrls: ['blockAccessOrder.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class BlockAccessOrderComponent implements OnInit, OnDestroy {
  constructor(
    public _blockStore: BlockStore,
    private _translateService: TranslateService,
    private _router: Router,
    private _cdr: ChangeDetectorRef
  ) {}

  subscriptions = new Subscription();
  isExpired: boolean;
  warnText: string;
  @Output() isTimeFinished = new EventEmitter<boolean>();
  ngOnInit() {
    this._blockStore.blockOrder.subscribe((res) => {
      this.redirectToOrdersList(res);
    });
    this._blockStore.blockOrderBehavior.subscribe((res) => {
      this.redirectToOrdersList(res);
    });

    this._blockStore.expireOrder.subscribe((res) => {
      this.isTimeFinished.emit(res);
    });
    this._blockStore.expireOrderBehavior.subscribe((res) => {
      this.isTimeFinished.emit(res);
    });
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  redirectToOrdersList(res) {
    this.warnText = null;

    if (
      res &&
      res.status &&
      res.currentStatusPage &&
      res.currentStatusPage != Number(res.status)
    ) {
      this.warnText = this._translateService.translations[
        this._translateService.currentLang
      ]['orderStatusMessageRedirectToOrders'].replace(
        '{status}',
        res.statusName
      );
      setTimeout(() => {
        this._router.navigateByUrl('dashboard/orders/invoices');
      }, 3000);
    }

    this._cdr.detectChanges();
  }
}
