import {
  ChangeDetectorRef,
  Component,
  Input,
  OnInit,
  OnChanges,
  OnDestroy,
} from '@angular/core';
import { Subscription } from 'rxjs';
import { DiscountCodeStore } from '@stores/getDiscount.store';
import { ScenarioStore } from '@stores/scenario.store';
import { GetScenarioCheckout } from '@models/orders/getScenarioCheckoutModel';

@Component({
  selector: 'factorDetails',
  templateUrl: 'factorDetails.component.html',
})
export class FactorDetailsComponent implements OnInit, OnChanges, OnDestroy {
  subscriptions = new Subscription();
  @Input() dataCheckout: any = null;
  @Input() isLoading: boolean;
  dataScenario: GetScenarioCheckout = new GetScenarioCheckout();
  public scenarioFinalAmount: number;

  constructor(
    private cdr: ChangeDetectorRef,
    public _dicountCodeStore: DiscountCodeStore,
    private _scenarioStore: ScenarioStore
  ) {
    this._scenarioStore.getScenarioBehavior().subscribe((res) => {
      if (res != null) {
        this.dataScenario = res;
      }
    });
  }

  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
    this.cdr.detectChanges();
  }

  ngOnChanges() {
    this.cdr.detectChanges();
  }

  ngOnInit() {
    if (this.dataScenario) {
      this.checkForScenario();
    }
  }

  checkForScenario() {
    if (this.dataScenario.isAllowed) {
      if (this.dataScenario.paymentOfOrderWage) {
        this.scenarioFinalAmount = this.dataCheckout.finalWageAmount;
      } else if (this.dataScenario.paymentWithoutOrderWage) {
        if (this.dataCheckout.discount) {
          this.scenarioFinalAmount =
            this.dataCheckout.discountedFinalAmount -
            this.dataCheckout.finalWageAmount;
        } else {
          this.scenarioFinalAmount =
            this.dataCheckout.finalAmount - this.dataCheckout.finalWageAmount;
        }
      } else {
        this.scenarioFinalAmount = this.dataCheckout.finalAmount;
      }
    } else if (this.dataCheckout.discount) {
      this.scenarioFinalAmount = this.dataCheckout.discountedFinalAmount;
    } else {
      this.scenarioFinalAmount = this.dataCheckout.finalAmount;
    }
    this.cdr.detectChanges();
  }
}
