import {
  AfterViewInit,
  ChangeDetectorRef,
  Component,
  EventEmitter,
  OnDestroy,
  OnInit,
  Output,
} from '@angular/core';

import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { IBankAccount } from '@interfaces/user/IBankAccount';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { UserProfile } from '@interfaces/user/userProfile';
import { DocumentsModel } from '@models/user/DocumentsModel';
import { VerifyingModel } from '@models/user/VerifyingModel';
import { TranslateService } from '@ngx-translate/core';
import { CommonService } from '@services/common.service';
import { StyleStore } from '@stores/style.store';
import { UserStore } from '@stores/user.store';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { Subscription, finalize } from 'rxjs';
import { BaseParams } from 'src/app/core/params/user/baseParams';

@Component({
  selector: 'modal-content',
  templateUrl: 'modalContentMobile.component.html',
  styleUrls: ['modalContentMobile.component.scss'],
})
export class ModalContentMobileComponent
  implements OnInit, AfterViewInit, OnDestroy
{
  @Output() onSave = new EventEmitter();
  activeIndex: number = 0;
  indexTab: number = 0;
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isLoadingGetDocument: boolean = false;
  isLoadingGetBankAccount: boolean = false;
  dataVerifying: VerifyingModel[] = [];
  data: UserProfile;
  documents: DocumentsModel[] = null;
  bankAccount: IBankAccount[] = [];
  nationalCardId: string = null;
  selfiImageId: string = null;
  isCompeleteBaseInformation: boolean = false;
  isCompeleteTel: boolean = false;
  isCompeleteEmail: boolean = false;
  isCompleteMobile: boolean = false;
  isCompeleteBanking: boolean = false;
  isCompeleteDocumentSelfi: boolean = false;
  isCompeleteDocumentNationalCard: boolean = false;
  query: BaseParams;
  errMsg: any;
  totalRecords: number = 0;
  isLoadingGetWallet: boolean;
  tabTitle: string;
  tabList = [];
  msg: string;
  minValue: string;
  minValueOrderSetting: number;
  isLoadingGetVerify: boolean;
  orderSetting: IExistVerifying;
  walletVerify: any[];
  msgBaseInfo: string =
    ' ابتدا باید اطلاعات پایه نظیر نام، نام خانوادگی، کد ملی و تاریخ تولد خود را در پنجره اول تکمیل کنید.';

  constructor(
    private _commonService: CommonService,
    private _userStore: UserStore,
    private cdr: ChangeDetectorRef,
    private _styleStore: StyleStore,
    private ref: DynamicDialogConfig,
    private _translateService: TranslateService,
    private refModal: DynamicDialogRef
  ) {}

  ngAfterViewInit() {
    if (this.ref?.data?.msg != null) {
      this.errMsg = this.ref.data.msg;
    }
    if (this.ref?.data?.orderSetting != null) {
      this.orderSetting = this.ref.data.orderSetting;
    }
    if (this.ref?.data?.minValue != null) {
      this.minValue = this.ref.data.minValue;
    }
    if (this.ref && this.ref.data && this.ref.data.missingFields != null) {
      this.walletVerify = this.ref.data.missingFields || [];
    }
    this.cdr.detectChanges();
  }

  ngOnInit(): void {
    this.errMsg = this.ref?.data?.msg ?? null;
    this.minValue = this.ref?.data?.minValue ?? null;
    this.orderSetting = this.ref?.data?.orderSetting ?? null;
    this._styleStore.layoutWith.next({
      width: 'w-full',
      isDashFooter: false,
    });
    this.isLoadingGet = true;
    this._userStore.user.subscribe((res) => {
      if (res != null) this.data = res;
      this.isLoadingGet = false;
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.isLoadingGet = false;
        this.data = res;
      }
    });
    this.userGetVerifying();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getBankAccount() {
    this.isLoadingGetBankAccount = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.BankAccountGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetBankAccount = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.bankAccount = response.data;
          },
          (error) => {}
        )
    );
  }

  userGetDocument() {
    this.isLoadingGetDocument = true;
    this.subscriptions.add(
      this._commonService
        .put(Address.DocumentGet, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetDocument = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.documents = response.data;
            if (this.documents != null) {
              for (let item of this.documents) {
                switch (item.documentType) {
                  case 136:
                    this.nationalCardId = item.fileId;
                    break;
                  case 139:
                    this.selfiImageId = item.fileId;
                    break;
                  default:
                    break;
                }
              }
            }
          },
          (error) => {}
        )
    );
  }

  userGetVerifying() {
    this.isLoadingGetVerify = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.UserVerifying, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetVerify = false;
          })
        )
        .subscribe(
          (response: response) => {
            this.dataVerifying = response.data;
            for (let item of this.dataVerifying) {
              switch (item.typeVerifying) {
                case 118:
                  if (item.isAccept) this.isCompeleteBaseInformation = true;
                  break;
                case 111:
                  if (item.isAccept) this.isCompleteMobile = true;
                  break;
                case 112:
                  if (item.isAccept) this.isCompeleteEmail = true;
                  break;
                case 113:
                  if (item.isAccept) this.isCompeleteTel = true;
                  break;
                case 114:
                  if (item.isAccept)
                    this.isCompeleteDocumentNationalCard = true;
                  break;
                case 116:
                  if (item.isAccept) this.isCompeleteDocumentSelfi = true;
                  this.isCompeleteBaseInformation = true;
                  break;
                case 115:
                  if (item.isAccept) this.isCompeleteBanking = true;
                  this.isCompeleteBaseInformation = true;
                  break;
              }
            }

            if (
              this.errMsg == 473 ||
              this.orderSetting?.checkBasicInformation ||
              ((this.errMsg == 472 || this.orderSetting?.checkBankAccount) &&
                !this.isCompeleteBaseInformation) ||
              ((this.errMsg == 475 || this.orderSetting?.checkNationalCard) &&
                !this.isCompeleteBaseInformation) ||
              ((this.errMsg == 474 || this.orderSetting?.checkSelfiImage) &&
                !this.isCompeleteBaseInformation)
            ) {
              if (
                this.errMsg == 473 ||
                this.orderSetting?.checkBasicInformation
              ) {
                if (this.walletVerify && this.walletVerify.length > 0) {
                  this.msg =
                    this._translateService.translations[
                      this._translateService.currentLang
                    ]['msg.basicInfo.wallet'];
                } else {
                  this.msg =
                    this._translateService.translations[
                      this._translateService.currentLang
                    ]['msg.basicInfo.order'];
                }
              } else if (
                ((this.errMsg == 472 || this.orderSetting?.checkBankAccount) &&
                  !this.isCompeleteBaseInformation) ||
                ((this.errMsg == 475 || this.orderSetting?.checkNationalCard) &&
                  !this.isCompeleteBaseInformation) ||
                ((this.errMsg == 474 || this.orderSetting?.checkSelfiImage) &&
                  !this.isCompeleteBaseInformation)
              ) {
                this.msg =
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['msg.addDocs.required'];
              }

              this.indexTab = 0;
              this.tabList.push({
                title:
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['tab.basicInfo'],
                msg: this.msg,
                tb: 0,
              });
            }

            if (
              this.errMsg == 475 ||
              this.orderSetting?.checkNationalCard ||
              (this.errMsg == 474 && !this.isCompeleteDocumentSelfi) ||
              this.errMsg == 474 ||
              this.orderSetting?.checkSelfiImage ||
              (this.errMsg == 475 && !this.isCompeleteDocumentNationalCard)
            ) {
              if (
                (!this.isCompeleteDocumentSelfi &&
                  this.isCompeleteDocumentNationalCard) ||
                this.orderSetting?.checkSelfiImage
              ) {
                if (this.isCompeleteBaseInformation) {
                  if (this.walletVerify && this.walletVerify.length > 0) {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.selfie.only.wallet'];
                  } else {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.selfie.only.order'];
                  }
                  this.indexTab = 1;
                } else {
                  if (this.walletVerify && this.walletVerify.length > 0) {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.selfie.needBasic.wallet'];
                  } else {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.selfie.needBasic.order'];
                  }
                  this.indexTab = 0;
                }
              }
              if (
                ((this.errMsg == 475 || this.orderSetting?.checkNationalCard) &&
                  !this.isCompeleteDocumentSelfi) ||
                ((this.errMsg == 474 || this.orderSetting?.checkSelfiImage) &&
                  !this.isCompeleteDocumentNationalCard)
              ) {
                if (this.isCompeleteBaseInformation) {
                  if (this.walletVerify && this.walletVerify.length > 0) {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.selfieAndNational.front.wallet'];
                  } else {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.selfieAndNational.front.order'];
                  }
                  this.indexTab = 1;
                } else {
                  if (this.walletVerify && this.walletVerify.length > 0) {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.selfieAndNational.front.needBasic.wallet'];
                  } else {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.selfieAndNational.front.needBasic.order'];
                  }
                  this.indexTab = 0;
                }
              }
              if (
                (!this.isCompeleteDocumentNationalCard &&
                  this.isCompeleteDocumentSelfi) ||
                this.orderSetting?.checkNationalCard
              ) {
                if (this.isCompeleteBaseInformation) {
                  if (this.walletVerify && this.walletVerify.length > 0) {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.national.only.wallet'];
                  } else {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.national.only.order'];
                  }
                  this.indexTab = 1;
                } else {
                  if (this.walletVerify && this.walletVerify.length > 0) {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.national.needBasic.wallet'];
                  } else {
                    this.msg =
                      this._translateService.translations[
                        this._translateService.currentLang
                      ]['msg.national.needBasic.order'];
                  }
                  this.indexTab = 0;
                }
              }

              this.tabList.push({
                title:
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['tab.selfieAndNational'],
                msg: this.msg,
                tb: 1,
              });
            }

            if (
              (this.errMsg == 470 || this.orderSetting?.checkMobile) &&
              !this.isCompleteMobile
            ) {
              this.indexTab = 2;
              if (this.walletVerify && this.walletVerify.length > 0) {
                this.msg =
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['msg.mobile.wallet'];
              } else {
                this.msg =
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['msg.mobile.order'];
              }
              this.tabList.push({
                title:
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['tab.verifyMobile'],
                msg: this.msg,
                tb: 2,
              });
            }

            if (
              (this.errMsg == 471 || this.orderSetting?.checkEmail) &&
              !this.isCompeleteEmail
            ) {
              this.indexTab = 3;
              if (this.walletVerify && this.walletVerify.length > 0) {
                this.msg =
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['msg.email.wallet'];
              } else {
                this.msg =
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['msg.email.order'];
              }
              this.tabList.push({
                title:
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['tab.verifyEmail'],
                msg: this.msg,
                tb: 3,
              });
            }

            if (
              (this.errMsg == 472 || this.orderSetting?.checkBankAccount) &&
              !this.isCompeleteBanking
            ) {
              this.indexTab = 4;
              if (this.walletVerify && this.walletVerify.length > 0) {
                this.msg =
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['msg.bank.wallet'];
              } else {
                this.msg =
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['msg.bank.order'];
              }
              this.tabList.push({
                title:
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['tab.addBank'],
                msg: this.msg,
                tb: 4,
              });
            }

            if (
              (this.errMsg == 476 || this.orderSetting?.checkPhone) &&
              !this.isCompeleteTel
            ) {
              this.indexTab = 5;
              if (this.walletVerify && this.walletVerify.length > 0) {
                this.msg =
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['msg.tel.wallet'];
              } else {
                this.msg =
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['msg.tel.order'];
              }
              this.tabList.push({
                title:
                  this._translateService.translations[
                    this._translateService.currentLang
                  ]['tab.verifyTel'],
                msg: this.msg,
                tb: 5,
              });
            }

            this.indexTab = 0;
            this.isLoadingGetVerify = false;
            this.cdr.detectChanges();
          },

          (error) => {}
        )
    );
  }

  checkIfAllRequiredCompleted() {
    const verifyingStatus = {
      checkBasicInformation:
        this.isCompeleteBaseInformation &&
        this.orderSetting?.checkBasicInformation,
      checkBankAccount: this.isCompeleteBanking,
      checkPhone: this.isCompeleteTel,
      checkEmail: this.isCompeleteEmail,
      checkMobile: this.isCompleteMobile,
      checkNationalCard: this.isCompeleteDocumentNationalCard,
      checkSelfiImage: this.isCompeleteDocumentSelfi,
    };

    const requiredChecks = Object.keys(verifyingStatus).filter(
      (key) => this.orderSetting?.[key]
    );

    const allCompleted = requiredChecks.every((key) => verifyingStatus[key]);

    if (allCompleted) {
      this.onSave.emit(true);
      this.refModal.close(true);
    } else {
      const nextIncompleteKey = requiredChecks.find(
        (key) => !verifyingStatus[key]
      );
      this.goToTabByKey(nextIncompleteKey);
    }
  }

  private goToTabByKey(key: string) {
    const keyToTbMap: { [k: string]: number } = {
      checkBasicInformation: 0,
      checkNationalCard: 1,
      checkSelfiImage: 1,
      checkMobile: 2,
      checkEmail: 3,
      checkBankAccount: 4,
      checkPhone: 5,
    };

    const targetTb = keyToTbMap[key];

    if (targetTb === undefined) {
      return;
    }

    const tabIndex = this.tabList.findIndex((t) => t.tb === targetTb);

    if (tabIndex === -1) {
      const firstMatch = this.tabList.findIndex((t) => t.tb === targetTb);
      this.indexTab = firstMatch !== -1 ? firstMatch : 0;
    } else {
      this.indexTab = tabIndex;
    }

    setTimeout(() => {
      this.cdr.detectChanges();
      const navItems = document.querySelectorAll('.p-tabview-nav li');
      navItems[this.indexTab]?.scrollIntoView({
        behavior: 'smooth',
        block: 'nearest',
        inline: 'center',
      });
    }, 0);
  }

  getInfoActionUser(e) {
    if (e) {
      this.isCompeleteBaseInformation = true;
      this.checkIfAllRequiredCompleted();
    }
  }

  getInfoActionBank(e) {
    if (e) {
      this.isCompeleteBanking = true;
      this.checkIfAllRequiredCompleted();
    }
  }

  getInfoActionTel(e) {
    if (e) {
      this.isCompeleteTel = true;
      this.checkIfAllRequiredCompleted();
    }
  }

  getInfoActionEmail(e) {
    if (e) {
      this.isCompeleteEmail = true;
      this.checkIfAllRequiredCompleted();
    }
  }

  getInfoActionMobile(e) {
    if (e) {
      this.isCompleteMobile = true;
      this.checkIfAllRequiredCompleted();
    }
  }
}
