import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { DialogService } from 'primeng/dynamicdialog';
import { ModalContentMobileComponent } from '../modalContentMobile.component';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';

@Component({
  selector: 'orderVerify',
  templateUrl: 'orderVerify.component.html',
  styleUrls: ['orderVerify.component.scss'],
})
export class OrderVerifyComponent {
  @Input() errMsg: any;
  @Input() styleClass: string = 'verifyingModal';
  @Input() width: string = '50%';
  @Input() height: string = '95%';
  @Input() header: string = 'احراز اطلاعات';
  @Input() orderSetting: IExistVerifying;
  @Output() modalClosed = new EventEmitter<boolean>();
  @Output() isVerifiedInfo: EventEmitter<boolean> = new EventEmitter<boolean>();
  minValue: number = null;
  constructor(public dialogService: DialogService) {}

  modalGetMobile() {
  const orderSetting = this.orderSetting ?? {};
  const toNum = (v: any) => (typeof v === 'number' ? v : 0);

  const values = [
    toNum(this.orderSetting.minAmountCheckBankAccount),
    toNum(this.orderSetting.minAmountCheckBasicInformation),
    toNum(this.orderSetting.minAmountCheckEmail),
    toNum(this.orderSetting.minAmountCheckMobile),
    toNum(this.orderSetting.minAmountCheckNationalCard),
    toNum(this.orderSetting.minAmountCheckPhone),
    toNum(this.orderSetting.minAmountCheckSelfi)
  ];

  this.minValue = Math.max(...values);

  const msg = this.errMsg ?? '';
  const msgStr = typeof msg === 'string' ? msg : String(msg);

  const ref = this.dialogService.open(ModalContentMobileComponent, {
    header: this.header,
    height: this.height,
    width: this.width,
    styleClass: this.styleClass,
    data: {
      msg: msgStr,
      orderSetting,
      minValue: this.minValue - 1,
      missingFields: null
    },
    dismissableMask: true,
  });

  ref?.onClose.subscribe((model: any) => {
    if (model) this.isVerifiedInfo.emit(true);
  });
  return ref;
}

}
