import { Component, OnInit, Input } from '@angular/core';
import { DomSanitizer } from '@angular/platform-browser';

@Component({
  selector: 'app-order-description',
  templateUrl: './orderDescription.component.html',
  styleUrls: ['./orderDescription.component.scss'],
})
export class OrderDescriptionComponent implements OnInit {
  @Input() content: any;
  @Input() header: string;
  isContentToggled: boolean;

  constructor(private sanitizer: DomSanitizer) {}

  ngOnInit() {
    this.content = this.sanitizer.bypassSecurityTrustHtml(this.content);
  }

  toggleContent() {
    this.isContentToggled = !this.isContentToggled;
  }
}
