import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
  OnChanges,
  OnInit,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { DeviceDetectorService } from 'ngx-device-detector';
import { finalize, Subscription } from 'rxjs';

@Component({
  selector: 'orderImage',
  templateUrl: 'orderImage.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderImageIdComponent implements OnInit, OnChanges {
  @Input() imageId: string;
  fileUrl: string;

  subscriptions = new Subscription();

  isDesktop: boolean;
  isLoadingGetFile: boolean;
  constructor(
    private cdr: ChangeDetectorRef,
    public _deviceDetectorService: DeviceDetectorService,
    private _commonService: CommonService
  ) {}

  ngOnInit() {
	if(this.imageId!=null || this.imageId!=''){
		this.getFileUrl()
	}
    this.cdr.detectChanges();
  }

  getFileUrl() {
    this.isLoadingGetFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + this.imageId)
        .pipe(
          finalize(() => {
            this.isLoadingGetFile = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.fileUrl = response;

            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }
  ngOnChanges() {}
}
