import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
  OnChanges,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { Subscription } from 'rxjs';
import { InboxSearch } from '@models/user/InboxSearch';
import { InboxListModel } from '@models/user/InboxListModel';
import { InboxModel } from '@models/dashboard/InboxModel';

@Component({
  selector: 'public-alarm',
  templateUrl: './publicAlarm.component.html',
  styleUrls: ['./publicAlarm.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})

export class PublicAlarmComponent implements OnInit, OnChanges, OnDestroy {
  constructor() {}

  subscriptions = new Subscription();
  inboxSearch: InboxSearch = new InboxSearch();
  inboxList: InboxListModel[] = [];
  @Input() dataInbox: InboxModel[] = [];
  @Input() isLoading: boolean = true;

  ngOnInit(): void {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  ngOnChanges() {}

  ngAfterViewInit() {}

  closeAlarmer(item: InboxModel) {
    item.isCloseAlarmer = true;
  }
}