import {Location} from '@angular/common';
import {Component} from '@angular/core';
import {SwUpdate} from '@angular/service-worker';
import { PwaService } from '@services/pwa.service';
 

@Component({
    selector: 'webApplicationPage',
    templateUrl: 'webApplicationPage.component.html',
    styleUrls: ['./webApplicationPage.component.scss']
})
export class WebApplicationPageComponent {


    installable: boolean

    constructor(
        public location: Location,
        private swUpdate: SwUpdate,
        private pwaService: PwaService
    ) {
    }


    visibleRoles: boolean = false;
    isDesktop: boolean;


    ngOnInit(): void {
        this.pwaService.installPromptEvent.subscribe((prompt) => {
            this.installable = !!prompt
        });
    }


    addToHomeScreen() {
        if (this.installable) {
            this.pwaService.promptInstall()
        }
    }

    goBackToPrevPage() {
        this.location.back();
    }
}



