import {
  CUSTOM_ELEMENTS_SCHEMA,
  NgModule,
  NO_ERRORS_SCHEMA,
  Optional,
  SkipSelf,
} from '@angular/core';
import { SharedModule } from '@shared/SharedModule';


import { SharedFormsModule } from '@shared/sharedForms.module';
import { WebApplicationPageRoutingModule } from './webApplicationPage.routes';
import { WebApplicationPageComponent } from './webApplicationPage.component';

@NgModule({
  declarations: [WebApplicationPageComponent],
  exports: [SharedModule, SharedFormsModule],
  imports: [WebApplicationPageRoutingModule, SharedModule, SharedFormsModule],
  providers: [],
  schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
})
export class WebApplicationPageModule {
  constructor(
    @Optional()
    @SkipSelf()
    parentModule: WebApplicationPageModule
  ) {
    if (parentModule) {
      throw new Error('WebApplicationPageModule is already loaded.');
    }
  }
}
