import { cloneDeep } from 'lodash-es';
import { Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ViewChild,
  ElementRef,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { UserStore } from '@stores/user.store';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { SellingPerfectMoneyPriceModel } from '@models/orders/sellingPerfectMoneyPriceModel';
import { SellingPerfectMoneySaveModel } from 'src/app/core/params/order/SellingPerfectMoneySaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { DetectHelper } from '@helpers/detectHelper';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from 'src/app/modules/services/components/legal-order/legal-order.component';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';

import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { TranslateService } from '@ngx-translate/core';
@Component({
  selector: 'dashboard-PerfectMoneySelling-order',
  templateUrl: './dashboard-PMSell.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderDashboardSellingPerfectMoneyComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isValidLegalForm: boolean = true;
  isLoadingGetCurrency: boolean = false;
  isLoadingGetPrice: boolean = false;
  
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  data: UserProfile;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  timeout = null;
  dataPrice: SellingPerfectMoneyPriceModel;
  model: SellingPerfectMoneySaveModel = new SellingPerfectMoneySaveModel();
  isLoading: boolean = false;

  isDesktop: boolean;
  limitNumber: number;
  totalQuestionRecord: number = 0;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  totalRecord: number = 0;
  orderType: number = 165;
  isVerifiedInfo: boolean = false;
  errMsg: any;

  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private _userStore: UserStore,
    private cdr: ChangeDetectorRef,
    private detectHelper: DetectHelper,
    private _router: Router,
    public _deviceDetectorService: DeviceDetectorService,
    private _translateService: TranslateService,
    public dialogService: DialogService
  ) {}

  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;

  ngOnInit(): void {
    this.isLoadingGet = true;
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this.cdr.detectChanges();
    this._userStore.user.subscribe((res) => {
      if (res != null) this.data = res;
      this.isLoadingGet = false;
    });

    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.isLoadingGet = false;
        this.cdr.detectChanges();
        this.data = res;
      }
    });
  }

  hideAlarmOrder(){
    this.isVerifiedInfo = true
    this.cdr.detectChanges();
  }

  ngAfterViewInit() {
    this.getCurrency();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  getCurrency() {
    this.isLoadingGetCurrency = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            orderType: this.orderType,
            isArchive: false,
            sort: 'sortNumber asc',
            pageSize: 50,moduleType: 30001
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetCurrency = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }
            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
              if (response.data.setting.data.maximumNumberPurchase) {
                this.limitNumber =
                  response.data.setting.data.maximumNumberPurchase;
              }
            }
            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }
            }
            this.model.currencyId = this.selectedCurrency.currencyId;
            if (
              !isNaN(Number(this.model.amount)) &&
              Number(this.model.amount) > 0
            ) {
              this.getPrice();
              this.cdr.detectChanges();
            }
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;

    this.subscriptions.add(
      this._commonService
        .put(Address.SellingPerfectMoneyGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = cloneDeep(response.data);
            this.inquiryIsOk = true;
          },
          (error) => {}
        )
    );
  }

  onFilter() {
    this.detectHelper.fullCompelete(this.cdr);
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();

      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.inquiryIsOk = false;
      this.cdr.detectChanges();
    }
  }
  
  submit() {
    if (!this.isValidLegalForm) return;
    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;

    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.SellingPerfectMoneySave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingperfectmoney/' +
                response.data.orderId
            );
          },
          (error) => {}
        )
    );
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }
}
