import {
  AfterViewInit,
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { VerifyingModel } from '@models/user/VerifyingModel';
import {
  getConfigCarouselOWL,
  getConfigCarouselOWLTopSticky,
} from '@helpers/dataStatic.helper';
import { AdvertisingModel } from '@models/dashboard/AdvertisingModel';
import { OwlOptions } from 'ngx-owl-carousel-o';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { StyleStore } from '@stores/style.store';
import { cloneDeep } from 'lodash-es';
import { DomSanitizer } from '@angular/platform-browser';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { PagingHelper } from '@helpers/paging.helper';
import { Router } from '@angular/router';
import { OrderSearchModel } from 'src/app/core/params/order/OrderSearchModel';
import { OrderListModel } from '@models/orders/OrderListModel';
import { MessageStatic } from '@enums/messageStatic.enum';
import { ValueTypeStore } from '@stores/getValueType.store';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderDetailsComponent } from '../orders/orderList/components/orderDetails/orderDetails.component';
import { InboxSearch } from '@models/user/InboxSearch';
import { InboxListModel } from '@models/user/InboxListModel';
import { SurveyModel } from '@models/orders/surveyModel';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { SurveyComponent } from '../survey/survey.component';
import { InboxModel } from '@models/dashboard/InboxModel';
import { FileUploadService } from '@services/fileUpload.service';
import { UserStore } from '@stores/user.store';
import { UserProfile } from '@interfaces/user/userProfile';
import { LoadUserData } from '@stores/loadUserData.store';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'dashboard',
  templateUrl: './dashboard.component.html',
  styleUrls: ['./dashboard.component.scss'],
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class DashboardComponent implements OnInit, OnDestroy, AfterViewInit {
  dataCurrency: CurrencyModel[] = [];
  customOptions: OwlOptions = getConfigCarouselOWL();
  customOptionsTopSticky: OwlOptions;
  subscriptions = new Subscription();
  dashboardContent: any;
  dashboardContentHtml: any;
  dataVerifyModel: VerifyingModel[] = [];
  isLoadingGetAdvertising: boolean = false;
  dataAdvertisingAll: AdvertisingModel[] = [];
  dataAdvertisingTopSticky: AdvertisingModel[] = [];
  dataAdvertisingTop: AdvertisingModel[] = [];
  dataAdvertisingMiddle: AdvertisingModel[] = [];
  dataAdvertisingBottom: AdvertisingModel[] = [];
  dataAdvertisingTopStickyMobile: AdvertisingModel[] = [];
  dataAdvertisingBottomStickyMobile: AdvertisingModel[] = [];
  dataAdvertisingBottomStickyRight: AdvertisingModel[] = [];
  dataAdvertisingBottomStickyLeft: AdvertisingModel[] = [];
  dataAdvertisingBottomMiddleStickyMobile: AdvertisingModel[] = [];
  dataAdvertisingTopMiddleStickyMobile: AdvertisingModel[] = [];
  dataAdvertisingTopHeader: AdvertisingModel[] = [];
  dataAdvertisingTopHeaderMobile: AdvertisingModel[] = [];
  surveyData: SurveyModel = new SurveyModel();
  isLoading: boolean = true;
  search: OrderSearchModel = new OrderSearchModel();
  staticValueType = [];
  first: number = 0;
  ticket: any;
  last: number = 0;
  data: OrderListModel[] = [];
  isLoadingTableData: boolean = false;
  query: BaseParams;
  totalRecords: number = 0;
  rowsPerPage = this._pagingHelper.rowsPersPage();
  activeIndex: number = 0;
  message: string = MessageStatic.NotFoundOrder;
  isLoadingReciept: boolean;
  fileUrl: string;
  isLoadingTest: boolean = true;
  index: any;
  isLoadingImg: boolean = true;
  inboxSearch: InboxSearch = new InboxSearch();
  inboxList: InboxListModel[] = [];
  isLoadingFileUrls: boolean = false;
  dataInbox: InboxModel[] = [];
  dataUser: UserProfile = null;
  isLoadingConnect: boolean = false;
  showTelegramAlarm: boolean = false;

  constructor(
    private _commonService: CommonService,
    private _styleStore: StyleStore,
    private sanitizer: DomSanitizer,
    public _pagingHelper: PagingHelper,
    private _router: Router,
    public dialogService: DialogService,
    public _valueTypeStore: ValueTypeStore,
    private cdr: ChangeDetectorRef,
    private _fileUploadService: FileUploadService,
    private _userStore: UserStore,
    private _loadUserData: LoadUserData,
    private _translateService: TranslateService,
  ) {
    this._userStore.getUser().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
        this.cdr.detectChanges();
      }
    });
    this._userStore.getUserBehavior().subscribe((res) => {
      if (res != null) {
        this.dataUser = res;
        this.cdr.detectChanges();
      }
    });
  }

  public ngAfterViewInit(): void {}

  ngOnInit(): void {
    this.customOptionsTopSticky = getConfigCarouselOWLTopSticky();
    this.getAllDashboard();
    const locationStr = localStorage.getItem('user-location');
    if (locationStr) {
      const location = JSON.parse(locationStr);
      if (location.countryCode == 'IR') {
        this.showTelegramAlarm = false;
      } else {
        this.showTelegramAlarm = true;
      }
    }
    this._styleStore.layoutWith.next({
      width: 'w-dashboard',
      isDashFooter: true,
    });
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getAllDashboard(): void {
    this.isLoadingGetAdvertising = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .get(Address.DashboardGetAll, {})
        .pipe(
          finalize(() => {
            this.isLoadingGetAdvertising = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res.data) {
            if (res.data.dasboardContent && res.data.dasboardContent.data) {
              this.dashboardContent = cloneDeep(res.data.dasboardContent.data);
              for (let item in this.dashboardContent) {
                this.dashboardContentHtml =
                  this.sanitizer.bypassSecurityTrustHtml(
                    this.dashboardContent[item]
                  );
              }
            }
            if (
              res.data.advertising != null &&
              res.data.advertising.data != null &&
              res.data.advertising.data.length > 0
            ) {
              this.dataAdvertisingAll = cloneDeep(res.data.advertising.data);

              this._fileUploadService.fileUrlGeneratorPutAdvertising(
                this.dataAdvertisingAll,
                'imageId'
              );

              this.dataAdvertisingTopSticky = this.dataAdvertisingAll.filter(
                (dataAd) => dataAd.position == 301 && dataAd.isActive
              );

              this.dataAdvertisingTop = this.dataAdvertisingAll.filter(
                (dataAd) => dataAd.position == 302 && dataAd.isActive
              );

              this.dataAdvertisingMiddle = this.dataAdvertisingAll.filter(
                (dataAd) => dataAd.position == 303 && dataAd.isActive
              );

              this.dataAdvertisingBottom = this.dataAdvertisingAll.filter(
                (dataAd) => dataAd.position == 304 && dataAd.isActive
              );

              this.dataAdvertisingTopStickyMobile =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 305 && dataAd.isActive
                );

              this.dataAdvertisingBottomStickyMobile =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 306 && dataAd.isActive
                );

              this.dataAdvertisingBottomStickyRight =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 307 && dataAd.isActive
                );

              this.dataAdvertisingBottomStickyLeft =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 308 && dataAd.isActive
                );

              this.dataAdvertisingTopMiddleStickyMobile =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 309 && dataAd.isActive
                );

              this.dataAdvertisingBottomMiddleStickyMobile =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 311 && dataAd.isActive
                );

              this.dataAdvertisingTopHeader = this.dataAdvertisingAll.filter(
                (dataAd) => dataAd.position == 322 && dataAd.isActive
              );

              this.dataAdvertisingTopHeaderMobile =
                this.dataAdvertisingAll.filter(
                  (dataAd) => dataAd.position == 323 && dataAd.isActive
                );
            }
            if (
              res.data.inbox != null &&
              res.data.inbox.data != null &&
              res.data.inbox.data.length > 0
            ) {
              for (let item of res.data.inbox.data) {
                if (item.importance == 153) {
                  this.dataInbox.push(item);
                }
              }
            }
          }
          this.isLoadingGetAdvertising = false;
          this.cdr.detectChanges();
          setTimeout(() => {
            window.dispatchEvent(new Event('resize'));
          }, 100);
          this.getOrderData();
        })
    );
  }

  conneectToTelegram() {
    this.isLoadingConnect = true;
    this.subscriptions.add(
      this._commonService
        .post(Address.ConnectToTelegram, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingConnect = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this._loadUserData.triggerReload();
            window.open(response.data, '_blank');
          },
          (error) => {}
        )
    );
  }

  getOrderData(event: any = null): void {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.query = new BaseParams();
    this.query.pageSize = 3;
    if (this.search.status) this.search.status = Number(this.search.status);
    Object.assign(this.query, this.search);
    this.query = this._pagingHelper.requestParamsSet(event, this.query);
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderGetAll, this.query)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            if (res.data[0]) {
              this.data[0] = cloneDeep(res.data[0]);
            }
            if (res.data[1]) {
              this.data[1] = cloneDeep(res.data[1]);
            }
            if (res.data[2]) {
              this.data[2] = cloneDeep(res.data[2]);
            }
          }
          this.isLoading = false;
          this.cdr.detectChanges();
        })
    );
  }

  downloadReciept(item: any) {
    this.isLoadingReciept = true;
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + item.fileOrderId)
        .pipe(
          finalize(() => {
            this.isLoadingReciept = false;
          })
        )
        .subscribe(
          (response) => {
            this.fileUrl = response;
            window.open(this.fileUrl, '_blank');
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  transactionsNavigator(item: OrderListModel) {
    this._router.navigateByUrl(
      '/dashboard/orders/transactions/' + item.orderId
    );
  }

  toggle(item: any) {
    item.overlayVisible = !item.overlayVisible;
  }

  openOrdrDetail(item: any = null) {
    this._valueTypeStore.valueType.next(item.valueType);
    const ref = this.dialogService.open(OrderDetailsComponent, {
      data: {
        id: item ? item.orderId : null,
        orderType: item ? item.orderType : null,
        valueType: item ? item.valueType : null,
      },
      header: this._translateService.instant('orderDetailsHeader', {
        orderTypeName: item.orderTypeName,
        orderNumber: item.orderNumber,
      }),
      height: '100%',
      styleClass: 'modal-order-details',
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {});
  }

  pay(item: any) {
    if (item.valueType) {
      switch (item.valueType) {
        case 'GFC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/giftcard/' + item.orderId
          );

          break;
        case 'IWP':
          this._router.navigateByUrl(
            '/dashboard/checkouts/internationalpayment/' + item.orderId
          );

          break;
        case 'PRM':
          this._router.navigateByUrl(
            '/dashboard/checkouts/premium-accounts/' + item.orderId
          );
          break;
        case 'PAC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/paypal-recharge/' + item.orderId
          );
          break;

        case 'PAB':
          this._router.navigateByUrl(
            '/dashboard/checkouts/paypal/' + item.orderId
          );
          break;
        case 'PAS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/paypal-sell/' + item.orderId
          );
          break;

        case 'SWF':
          this._router.navigateByUrl(
            '/dashboard/checkouts/swift/' + item.orderId
          );
          break;

        case 'APG':
          this._router.navigateByUrl(
            '/dashboard/checkouts/fee-multiple/' + item.orderId
          );
          break;
        case 'PVS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/voucherperfectmoneysell/' + item.orderId
          );
          break;

        case 'PMS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/sellingperfectmoney/' + item.orderId
          );
          break;
        case 'PVC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/voucherperfectmoneybuy/' + item.orderId
          );
          break;
        case 'PMC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/perfectmoneybuying/' + item.orderId
          );
          break;

        case 'WIC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/wiseaccountcharge/' + item.orderId
          );
          break;
        case 'WIS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/sellingwise/' + item.orderId
          );
          break;
        case 'PYC':
          this._router.navigateByUrl(
            '/dashboard/checkouts/payeeraccountrecharge/' + item.orderId
          );
          break;
        case 'PYS':
          this._router.navigateByUrl(
            '/dashboard/checkouts/sellingpayeer/' + item.orderId
          );
          break;

        case 'TRI':
          this._router.navigateByUrl(
            '/dashboard/checkouts/remittancetoIran/' + item.orderId
          );
          break;

        case 'FRE':
          this._router.navigateByUrl(
            '/dashboard/checkouts/freeorder/' + item.orderId
          );
          break;

        case 'ICX':
          this._router.navigateByUrl(
            '/dashboard/checkouts/incomecash/' + item.orderId
          );
          break;
      }
    } else {
      if (item.status == 181 || item.status == 192) {
        switch (item.orderType) {
          case 161:
            this._router.navigateByUrl(
              '/dashboard/checkouts/swift/' + item.orderId
            );
            break;

          case 909:
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal/' + item.orderId
            );
            break;

          case 910:
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal-recharge/' + item.orderId
            );
            break;

          case 171:
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal-sell/' + item.orderId
            );
            break;

          case 940:
            this._router.navigateByUrl(
              '/dashboard/checkouts/paypal-sell/' + item.orderId
            );
            break;

          case 162:
            this._router.navigateByUrl(
              '/dashboard/checkouts/fee/' + item.orderId
            );
            break;
          case 905:
            this._router.navigateByUrl(
              '/dashboard/checkouts/fee-multiple/' + item.orderId
            );
            break;
          case 175:
            this._router.navigateByUrl(
              '/dashboard/checkouts/university-tuition/' + item.orderId
            );
            break;
          case 177:
            this._router.navigateByUrl(
              '/dashboard/checkouts/dormitory-fee/' + item.orderId
            );
            break;
          case 163:
            this._router.navigateByUrl(
              '/dashboard/checkouts/perfectmoneybuying/' + item.orderId
            );
            break;
          case 178:
            this._router.navigateByUrl(
              '/dashboard/checkouts/virtualServers/' + item.orderId
            );
            break;
          case 179:
            this._router.navigateByUrl(
              '/dashboard/checkouts/virtualServers/' + item.orderId
            );
            break;
          case 900:
            this._router.navigateByUrl(
              '/dashboard/checkouts/virtualServers/' + item.orderId
            );
            break;
          case 901:
            this._router.navigateByUrl(
              '/dashboard/checkouts/virtualServers/' + item.orderId
            );
            break;
          case 164:
            this._router.navigateByUrl(
              '/dashboard/checkouts/voucherperfectmoneybuy/' + item.orderId
            );
            break;
          case 166:
            this._router.navigateByUrl(
              '/dashboard/checkouts/voucherperfectmoneysell/' + item.orderId
            );
            break;
          case 165:
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingperfectmoney/' + item.orderId
            );
            break;
          case 167:
            this._router.navigateByUrl(
              '/dashboard/checkouts/remittancetoIran/' + item.orderId
            );
            break;
          case 173:
            this._router.navigateByUrl(
              '/dashboard/checkouts/wiseaccountcharge/' + item.orderId
            );
            break;
          case 907:
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingwise/' + item.orderId
            );
            break;

          case 169:
            this._router.navigateByUrl(
              '/dashboard/checkouts/payeeraccountrecharge/' + item.orderId
            );
            break;
          case 906:
            this._router.navigateByUrl(
              '/dashboard/checkouts/sellingpayeer/' + item.orderId
            );
            break;

          case 999:
            this._router.navigateByUrl(
              '/dashboard/checkouts/freeorder/' + item.orderId
            );
            break;
          case 959:
            this._router.navigateByUrl(
              '/dashboard/checkouts/incomecash/' + item.orderId
            );
            break;
        }
      }
    }
    if (item.status == 188) {
      this._router.navigateByUrl(
        '/dashboard/orders/depositDocument/' +
          item.orderType +
          '/' +
          item.orderId
      );
    }
  }

  navigateToOrders() {
    this._router.navigateByUrl('/dashboard/orders');
  }

  onImageLoad(evt) {
    if (evt && evt.target) {
      this.isLoadingImg = false;
    }
  }

  openWisePage() {
    this._router.navigateByUrl('/dashboard/services/wise/accountRecharge');
  }

  allServicesPage() {
    this._router.navigateByUrl('/dashboard/services');
  }

  modalSurvey(isFromOrderDetails: boolean = null, item: OrderListModel = null) {
    if (!stringIsEmptyOrNull(this.surveyData.comment)) {
      this.surveyData.comment = '';
    }
    if (this.surveyData.score) {
      this.surveyData.score = 0;
    }
    this.surveyData.orderId = item.orderId;
    const ref = this.dialogService.open(SurveyComponent, {
      data: {
        surveyData: this.surveyData,
        isFromOrderDetails: isFromOrderDetails,
      },
      header: 'نظرسنجی',
      dismissableMask: true,
      styleClass: 'modal-order-details-survey',
      closable: true,
      height: '95%',
      width: '40%',
    });
    ref.onClose.subscribe((model: any) => {
      if (model) {
        this.getOrderData();
      }
    });
  }
}
