import {Component, OnInit} from '@angular/core';
import {MenuItem} from 'primeng/api';
import {ActivatedRoute, Router } from '@angular/router';
@Component({
  selector: 'app-breadcrumb',
  templateUrl: './breadcrumb.component.html',
  styleUrls: ['./breadcrumb.component.scss']
})
export class BreadcrumbComponent implements OnInit {
  static readonly ROUTE_DATA_BREADCRUMB = 'breadcrumb';
  readonly home = { icon: 'pi pi-home', routerLink: '/dashboard/home' };
  menuItems: MenuItem[];

  constructor(private router: Router, private activatedRoute: ActivatedRoute) {}

  ngOnInit(): void {
    this.router.events
      .subscribe(() => this.menuItems = this.createBreadcrumbs(this.activatedRoute.root));
      
  }    

  private createBreadcrumbs(route: ActivatedRoute, url: string = '', breadcrumbs: MenuItem[] = []): MenuItem[] {
    const children: ActivatedRoute[] = route.children;

    if (children.length === 0) {
      return breadcrumbs;
    }

    for (const child of children) {
      const routeURL: string = child.snapshot.url.map(segment => segment.path).join('/');
      if (routeURL !== '') {
        url += `/${routeURL}`;
      }

      const label = child.snapshot.data[BreadcrumbComponent.ROUTE_DATA_BREADCRUMB];
      if (label != undefined && label!=null && Array.isArray(label)) {
        for(let item of label)
        {
          if(!item.isBlock)
          breadcrumbs.push({label:item.title, url:item.url});
        }
 
       
      }
      else if (label != undefined && label!=null && label!='') {
        breadcrumbs.push({label, url});
      }
      return this.createBreadcrumbs(child, url, breadcrumbs);
    }
    return null;
  }
}