import {
  Component,
  OnInit,
  ViewEncapsulation,
  OnDestroy,
  HostListener,
  ChangeDetectorRef,
  AfterViewInit,
  ViewChild,
  OnChanges,
} from '@angular/core';
import { finalize, Subscription } from 'rxjs';
import { MenuItem } from 'primeng/api/public_api';
import { StyleStore } from '@stores/style.store';
import { UserProfile } from '@interfaces/user/userProfile';
import { ActivatedRoute, Router } from '@angular/router';
import { Address } from '@enums/address.enum';
import { response } from '@interfaces/response';
import { CommonService } from '@services/common.service';
import { UserStore } from '@stores/user.store';
import { DialogService } from 'primeng/dynamicdialog';
import { InboxSearch } from '@models/user/InboxSearch';
import { SignalrService } from '@services/signalr.service';
import { RealTimeStore } from '@stores/realTime.store';
import { InboxListModel } from '@models/user/InboxListModel';
import { ColumnKey } from '@enums/columnKey.enum';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { scrollTop } from '@helpers/window.helper';
import { DeviceDetectorService } from 'ngx-device-detector';
import { MenuComponent } from './menu/menu.component';
import { MenuStateStore } from '@stores/loadMenu.store';
import { SearchBoxComponent } from './searchBox/searchBox.component';
import { SupportPhoneNumbersStore } from '@stores/loadSupportPhoneNumbers.store';
import { ISupportPhoneNumbers } from '@interfaces/dbo/iSupportPhoneNumbers';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { LoadUserData } from '@stores/loadUserData.store';
import { GoogleTagManagerEventService } from '@services/googleTagManagerEvent.service';
import { getStorageItem } from '@helpers/localstorage.helper';
import { getCookieItem } from '@helpers/cookie.helper';
@Component({
  selector: 'layout',
  templateUrl: 'layout.component.html',
  styleUrls: ['./layout.component.scss'],
  encapsulation: ViewEncapsulation.None,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class LayoutComponent
  implements OnInit, OnDestroy, AfterViewInit, OnChanges {
  constructor(
    private _commonService: CommonService,
    private _styleStore: StyleStore,
    private _router: Router,
    public dialogService: DialogService,
    private cdr: ChangeDetectorRef,
    private _userStore: UserStore,
    private _menuStateStore: MenuStateStore,
    private _supportPhoneNumbersStore: SupportPhoneNumbersStore,
    private signalRService: SignalrService,
    private _realTimeStore: RealTimeStore,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute,
    private _loadUserData: LoadUserData,
    private _googleTagManagerEventService: GoogleTagManagerEventService
  ) {
    this._menuStateStore.menu.subscribe((res) => {
      this.menuState = res;
    });
    this._supportPhoneNumbersStore.phoneNumbers.subscribe((res) => {
      this.menuState = res;
    });
    this._loadUserData.reloadUserData$.subscribe(() => {
      this.getFullUser();
    });
  }
  ngOnChanges() { }
  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }
  publicAlarm: string =
    'کاربر گرامی، شرکت فراکنش به هیچ عنوان نماینده ای ندارد و تمام پرداخت ها توسط خود سایت و از طریق پنل کاربری انجام میشوند. لذا برای انجام سفارش در جاهای دیگر در سایت فراکنش احراز هویت  نکنید.';
  isDesktop: boolean;
  query: BaseParams = new BaseParams();
  subscriptions = new Subscription();
  menuItems: MenuItem[];
  showSide = false;
  data: UserProfile;
  phoneNumbers: UserProfile;
  inboxSearch: InboxSearch = new InboxSearch();
  supportAndTickets: [] = [];
  inboxList: InboxListModel[] = [];
  openMenuProfile: boolean = false;
  totalRecords: number = 0;
  isScrollUp: boolean;
  layoutWidth: string = 'w-full';
  selectedLanguage: string = 'fa';
  menuState: boolean;
  supportPhoneNumbers: boolean;
  isLoadingGetFull: boolean;
  isLoadingGetSupportPhoneNumbers: boolean = false;
  totalRecordsTickets: any;
  @ViewChild('menu') menu: MenuComponent;
  themMode: boolean = true;
  isDashboard: boolean = false;
  supportPhoneNumbersList: ISupportPhoneNumbers[] = [];

  onActivate(event) {
    scrollTop();
  }

  changeLanguagePanel(e: string = null) { }

  ngAfterViewInit(): void {
    this.changeLanguagePanel();
  }
  ngOnInit() {
    if (this._activatedRoute.snapshot['_routerState'].url.indexOf('en') > 0) {
      this.selectedLanguage = 'en';
    }

    this.isDesktop = this._deviceDetectorService.isDesktop();
    this._styleStore.layoutWith.subscribe((res) => {
      this.layoutWidth = String(res['width']);
      this.isDashboard = res['isDashFooter'];
    });

    this.signalRService.connect();
    this._realTimeStore.realTimeData.subscribe((res) => {
      var msgArray = [];
      if (res != null && res['message'] != null) {
        msgArray = res['message'].split('::');
      }
      if (msgArray[0] == 'InboxGet' && this.data.userId == msgArray[1]) {
        this.userGetInbox();
      }
    });
    this.getSupportPhoneNumbers();

    this.getFullUser();
    this.saveClientTrackingDataExternal();
    this.cdr.detectChanges();
  }

  getSupportPhoneNumbers() {
    this.isLoadingGetSupportPhoneNumbers = true;
    this.subscriptions.add(
      this._commonService
        .get(Address.GetSupportPhoneNumbers, { location: 30001 }, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetSupportPhoneNumbers = false;
            this.cdr.detectChanges();
            this._supportPhoneNumbersStore.phoneNumbers.next(
              this.isLoadingGetSupportPhoneNumbers
            );
            this._supportPhoneNumbersStore.phoneNumbersBehavior.next(
              this.isLoadingGetSupportPhoneNumbers
            );
          })
        )
        .subscribe(
          (response: response) => {
            this.supportPhoneNumbersList = response.data.filter(
              (q) => !stringIsEmptyOrNull(q.phoneNumber)
            );

            this.cdr.detectChanges();
          },
          (error) => { }
        )
    );
  }
  getFullUser() {
    this.isLoadingGetFull = true;
    this.cdr.detectChanges();
    this._menuStateStore.menu.next(this.isLoadingGetFull);
    this._menuStateStore.menuBehavior.next(this.isLoadingGetFull);
    this.subscriptions.add(
      this._commonService
        .put(Address.UserGetFullPage, {}, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetFull = false;
            this.cdr.detectChanges();
            this._menuStateStore.menu.next(this.isLoadingGetFull);
            this._menuStateStore.menuBehavior.next(this.isLoadingGetFull);
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.user) {
              this.data = response.data.user.data;
              this._userStore.user.next(this.data);
              this._userStore.userBehavior.next(this.data);
            }

            if (response.data.menu) {
              this.menuItems = response.data.menu.data;
            }

            if (response.data.inbox) {
              this.inboxSearch.isNew = true;
              this.query.pageSize = 5;
              Object.assign(this.query, this.inboxSearch);
              this.inboxList = response.data.inbox.data;
              this.totalRecords = response.data.inbox.actualSize;
            }

            if (
              response.data.counts &&
              response.data.counts.data &&
              response.data.counts.data.ticketCount
            ) {
              this.query.pageSize = 5;

              this.totalRecordsTickets = response.data.counts.data.ticketCount;
            }

            this.cdr.detectChanges();
          },
          (error) => { }
        )
    );
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  changeStyle() {
    this.showSide = !this.showSide;
    this._styleStore.contentWidth.next({
      width: '70%',
    });
  }

  getStatus(e) {
    this.openMenuProfile = e;
  }

  userGetInbox() {
    setTimeout(() => {
      this.inboxSearch.isNew = true;
      this.query.pageSize = 5;
      Object.assign(this.query, this.inboxSearch);
      this.subscriptions.add(
        this._commonService
          .put(Address.InboxGet, this.query, false)
          .pipe(finalize(() => { }))
          .subscribe(
            (response: response) => {
              this.inboxList = response.data;

              this.totalRecords = response[ColumnKey.TotalRecordKey]
                ? response[ColumnKey.TotalRecordKey]
                : 0;
            },
            (error) => { }
          )
      );
    }, 100);
  }

  saveClientTrackingDataExternal() {
    let gA4ClientId = this._googleTagManagerEventService.getClientId();
    let goftinoKey = null;
    let goftinoData = null;
    for (let i = 0; i < localStorage.length; i++) {
      const key = localStorage.key(i);
      if (key && key.startsWith('goftino_') && key.includes('_fp')) {
        goftinoKey = key;
        break;
      }
    }
    if (goftinoKey) {
      goftinoData = getStorageItem(goftinoKey);
    }
    let clarityCLSK = getCookieItem("_clsk");
    let clarityCLCK = getCookieItem("_clck");
    let yektanetYNGT = getStorageItem(ColumnKey.YektanetId);
    let gA4Token = getStorageItem(ColumnKey.AnalyticsToken);
    setTimeout(() => {

      this.subscriptions.add(
        this._commonService
          .post(Address.ClientTrackingDataExternalSave, {
            gA4ClientId: gA4ClientId, goftinoFP: goftinoData
            , clarityCLSK: clarityCLSK, yektanetYNGT: yektanetYNGT, gA4Token: gA4Token, clarityCLCK: clarityCLCK
          })
          .pipe(finalize(() => { }))
          .subscribe(
            (response: response) => {
            },
            (error) => { }
          )
      );
    }, 100);
  }

  hide() {
    this.showSide = false;
  }
  goToHome() {
    this._router.navigateByUrl('/dashboard/home');
  }

  openNotif(id: string) {
    this._router.navigateByUrl('/dashboard/inbox/' + id);
  }

  searchModal() {
    const ref = this.dialogService.open(SearchBoxComponent, {
      header: 'جستجو در فراکنش',
      styleClass: 'search-modal',
      dismissableMask: true,
    });
    ref.onClose.subscribe((model: any) => {
      if (model) {
        this.cdr.detectChanges();
      }
    });
  }
}
