import {CUSTOM_ELEMENTS_SCHEMA, NgModule, NO_ERRORS_SCHEMA, Optional, SkipSelf} from '@angular/core';
import { SharedModule } from '@shared/SharedModule';
import { LayoutRoutingModule } from './layout.routes';
import { HeaderComponent } from './header/header.component';
import { FooterComponent } from './footer/footer.component';
import { LayoutComponent } from './layout.component';
import { MenuModule } from 'primeng/menu';
import { UserModule } from '../user/user.module';
import { BreadcrumbComponent } from './breadcrumb/breadcrumb.component';
import { SearchBoxComponent } from './searchBox/searchBox.component';
import { LanguageComponent } from './language/language.component';
import { MenuComponent } from './menu/menu.component';
@NgModule({
    declarations: 
    [
        HeaderComponent,
        FooterComponent,
        LayoutComponent,
        SearchBoxComponent,
        BreadcrumbComponent,
        LanguageComponent,
        MenuComponent
    ],
    exports: [],
    imports: [LayoutRoutingModule,SharedModule,MenuModule,UserModule],
    providers: [],
    schemas:[CUSTOM_ELEMENTS_SCHEMA,NO_ERRORS_SCHEMA]
})
export class LayoutModule {
    constructor(
        @Optional()
        @SkipSelf()
        parentModule: LayoutModule
    ) {
        if (parentModule) {
            throw new Error(
                'LayoutModule is already loaded.'
            );
        }
    }
  
}
