
import {   NgModule } from '@angular/core';
import {  RouterModule, Routes } from '@angular/router';
import { LayoutComponent } from './layout.component';
const routes: Routes = [
  {
    path: '',
    component: LayoutComponent,
    children: [
      { path: '', pathMatch: 'full', redirectTo: 'home' },

      {
        path: 'home',
        data: { title: 'داشبورد' },
        loadChildren: () =>
          import('../dashboard/dashboard.module').then(
            (m) => m.DashboardModule
          ),
      },
      
      {
        path: 'home/:language',
        data: { title: 'داشبورد' },
        loadChildren: () =>
          import('../dashboard/dashboard.module').then(
            (m) => m.DashboardModule
          ),
      },

      {
        path: 'errors',
        loadChildren: () =>
          import('../../errors/errors.module').then((m) => m.ErrorsModule),
      },
      {
        path: 'errors/:language',
        loadChildren: () =>
          import('../../errors/errors.module').then((m) => m.ErrorsModule),
      },
      {
        path: 'user',
        data: { title: 'اطلاعات من'  },
        loadChildren: () =>
          import('../user/user.module').then((m) => m.UserModule),
      },
      {
        path: 'user/:active',
        data: { title: 'اطلاعات من' },
        loadChildren: () =>
          import('../user/user.module').then((m) => m.UserModule),
      },
      {
        path: 'user/:active/:language',
        data: { title: 'اطلاعات من' },
        loadChildren: () =>
          import('../user/user.module').then((m) => m.UserModule),
      },
     
      {
        path: 'services',
        data: { title: 'خدمات',
     },
        loadChildren: () =>
          import('../services/services.module').then(
            (m) => m.ServicesModule
          ),
      },

            
      {
        path: 'Cat',
        data: {
          title: 'صفحه دسته بندی',
          breadcrumb: [{ title: 'صفحه دسته بندی', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            '../services/servicesCategory/servicesCategory.module'
          ).then((m) => m.ServicesCategoryModule),
      },
      {
        path: 'Cat/:language',
        data: {
          title: 'صفحه دسته بندی',
          breadcrumb: [{ title: 'صفحه دسته بندی', url: '/dashboard/services' }],
        },
        loadChildren: () =>
          import(
            '../services/servicesCategory/servicesCategory.module'
          ).then((m) => m.ServicesCategoryModule),
      },
      
      
      {
        path: 'orders',
        data: { title: 'سفارش های من' },
        loadChildren: () =>
          import('../orders/orders.module').then(
            (m) => m.OrdersModule
          ),
      },
      {
        path: 'checkouts',
        data: { title: 'سفارش های من' },
        loadChildren: () =>
          import('../checkouts/checkouts.module').then(
            (m) => m.CheckoutsModule
          ),
      },
      {
        path: 'orders/:language',
        data: { title: 'سفارش های من' },
        loadChildren: () =>
          import('../orders/orders.module').then(
            (m) => m.OrdersModule
          ),
      },
 
      {
        path: 'tickets',
        data: { title: 'تیکت ها' },
        loadChildren: () =>
          import('../support/tickets/tickets.module').then(
            (m) => m.TicketsModule
          ),
      },
      {
        path: 'tickets/:language',
        data: { title: 'تیکت ها' },
        loadChildren: () =>
          import('../support/tickets/tickets.module').then(
            (m) => m.TicketsModule
          ),
      },

      {
        path: 'inbox/:inboxId',
        data: { title: 'صندوق پیغام' },
        loadChildren: () =>
          import('../support/inbox/inbox.module').then((m) => m.InboxModule),
      },
      {
        path: 'inbox/:inboxId/:language',
        data: { title: 'صندوق پیغام' },
        loadChildren: () =>
          import('../support/inbox/inbox.module').then((m) => m.InboxModule),
      },
      
      { path: '**', redirectTo: 'errors' },
    ],
  },
];
@NgModule({
    imports: [[RouterModule.forChild(routes)] ],
      exports: [RouterModule]
})
export class LayoutRoutingModule { }
