import {
  ChangeDetectorRef,
  Component,
  EventEmitter,
  HostListener,
  Input,
  OnChanges,
  OnInit,
  Output,
} from '@angular/core';
import { Router } from '@angular/router';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { ISupportPhoneNumbers } from '@interfaces/dbo/iSupportPhoneNumbers';
import { DeviceDetectorService } from 'ngx-device-detector';
import { MenuItem } from 'primeng/api';
import { MessageService } from 'primeng/api/messageservice';
import { Subscription } from 'rxjs';

@Component({
  selector: 'muenu-service',
  templateUrl: 'menu.component.html',
  styleUrls: ['menu.component.scss'],
})
export class MenuComponent implements OnInit, OnChanges {
  subscriptions = new Subscription();
  isDesktop: boolean;
  isLoading: boolean;
  messageService: MessageService;
  @Input() showSide: boolean = false;
  @Output() showSideChange = new EventEmitter<boolean>();
  menuItems: MenuItem[] = [];
  @Input() menuItemsResponsed: any[] = [];
  @Input() supportPhoneNumbersList: ISupportPhoneNumbers[] = [];
  constructor(
    public _deviceDetectorService: DeviceDetectorService,
    private cdr: ChangeDetectorRef,
    private _router: Router
  ) {}

  ngOnChanges() {
    if (this.menuItemsResponsed && this.menuItemsResponsed.length > 0) {
      this.getMenu();
    }
    this.cdr.detectChanges();
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  ngOnInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  fillSubMenu(menuList: MenuItem[] = [], responseMenuList: any[] = []) {
    for (let item of menuList) {
      item.items = [];
      for (let responseItem of responseMenuList) {
        if (item.id == responseItem.parentId) {
          if (
            stringIsEmptyOrNull(responseItem.urlAddress) ||
            responseItem.urlAddress == '#'
          ) {
            item.items.push({
              visible: true,
              label: responseItem.title,
              expanded: false,
              icon: responseItem.icon,
              id: responseItem.menuId,
              styleClass: responseItem.className,
            });
          } else {
            item.items.push({
              visible: true,
              label: responseItem.title,
              expanded: false,
              icon: responseItem.icon,
              routerLink: responseItem.urlAddress,
              id: responseItem.menuId,
              styleClass: responseItem.className,
              command: () => {
                this.hide();
              },
            });
          }
        }
      }
      this.fillSubMenu(item.items, responseMenuList);
    }
  }
  getMenu() {
    this.menuItems = [];

    for (let item of this.menuItemsResponsed) {
      if (item.parentId == null) {
        if (stringIsEmptyOrNull(item.urlAddress) || item.urlAddress == '#') {
          if (item.title == 'خدمات') {
            this.menuItems.push({
              visible: true,
              label: item.title,
              expanded: true,
              icon: item.icon,
              id: item.menuId,
            });
          } else {
            this.menuItems.push({
              visible: true,
              label: item.title,
              expanded: false,
              icon: item.icon,
              id: item.menuId,
            });
          }
        } else {
          this.menuItems.push({
            visible: true,
            label: item.title,
            expanded: false,
            icon: item.icon,
            routerLink: item.urlAddress,
            id: item.menuId,

            command: () => {
              this.hide();
            },
          });
        }
      }
    }
    this.fillSubMenu(this.menuItems, this.menuItemsResponsed);
  }

  hide() {
    this.showSide = false;
    this.showSideChange.emit(false);
  }

  goToHome() {
    this._router.navigateByUrl('/dashboard/home');
  }
}
