import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnInit,
} from '@angular/core';
import { Router } from '@angular/router';
import { Address } from '@enums/address.enum';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { response } from '@interfaces/response';
import { CommonService } from '@services/common.service';
import { StyleStore } from '@stores/style.store';
import { cloneDeep } from 'lodash-es';
import { DeviceDetectorService } from 'ngx-device-detector';
import { MessageService } from 'primeng/api/messageservice';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { OverlayPanel } from 'primeng/overlaypanel';
import { Subscription, finalize } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';

@Component({
  selector: 'search-box',
  templateUrl: 'searchBox.component.html',
  styleUrls: ['searchBox.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class SearchBoxComponent implements OnInit {
  subscriptions = new Subscription();
  searchResult: any;
  isLoading: boolean = false;
  inputSearch;
  timeout: any = null;
  op;
  isDesktop: boolean;
  messageService: MessageService;
  isShow: boolean = true;

  constructor(
    public _deviceDetectorService: DeviceDetectorService,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _styleStore: StyleStore,
    private _router: Router,
    public ref: DynamicDialogRef,
    public config: DynamicDialogConfig
  ) {}

  ngOnInit(): void {
    this.isDesktop = this._deviceDetectorService.isDesktop();
    if (!this.isDesktop && this._router.url.indexOf('services') > 0) {
      this.isShow = false;
    }
    this._styleStore.showSearchBox.subscribe((res) => {
      if (
        res != undefined &&
        res != null &&
        res['showSearchBox'] != undefined &&
        res['showSearchBox'] != null
      )
        this.isShow = res['showSearchBox'];
    });
    this.cdr.detectChanges();
  }

  countSearchInput(op: OverlayPanel) {
    if (
      !stringIsEmptyOrNull(this.inputSearch) &&
      this.inputSearch.length >= 1
    ) {
      this.getResult(op, event);
    }
  }

  getResult(op: OverlayPanel, e: any) {
    clearTimeout(this.timeout);
    this.timeout = setTimeout(() => {
      this.isLoading = true;
      this.cdr.detectChanges();
      this.subscriptions.add(
        this._commonService
          .put(Address.SearchBoxApi, {
            search: this.inputSearch,
            key: 'customermenu',
          })
          .pipe(
            finalize(() => {
              this.isLoading = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe((res: response) => {
            if (res) {
              let resData;
              resData = cloneDeep(res.data);
              this.searchResult = resData.filter(
                (q) => q.urlAddress.split('dashboard/')[1] != '#'
              );

              if (
                !stringIsEmptyOrNull(this.inputSearch) &&
                this.searchResult.length > 1 &&
                op &&
                e
              ) {
                op.show(e);
              }

              this.cdr.detectChanges();
            }
          })
      );
    }, 700);
  }
}