import { Component, Input, OnDestroy, OnInit } from '@angular/core';
import { MessageStatic } from '@enums/messageStatic.enum';
import { Subscription } from 'rxjs';

@Component({
    selector: 'publicDetailsDiscount',
    templateUrl: 'publicDetailsDiscount.component.html'
})

export class PublicDetailsDiscountComponent implements OnInit, OnDestroy {
    constructor(
    ) { }
    subscriptions = new Subscription();
    @Input() item;
    discountPrice : number
    message: string = MessageStatic.NotFound;
    ngOnInit() {
        if(this.item && this.item.finalAmount && this.item.discountedFinalAmount){
            this.discountPrice = this.item.finalAmount - this.item.discountedFinalAmount
        }
    }

    ngOnDestroy() {
        this.subscriptions.unsubscribe();
    }
}