import { Component, Input, OnDestroy } from '@angular/core';
import { MessageStatic } from '@enums/messageStatic.enum';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { Subscription } from 'rxjs';

@Component({
	selector: 'wiseSellingDetail',
	templateUrl: 'wiseSellingDetail.component.html'
})

export class WiseSellingDetailComponent implements OnDestroy {
	constructor(
	 ) { }
	 subscriptions = new Subscription();
	 @Input() item;
	 @Input() uploadedFiles: IAdditionalFields[];
	 timeout = null;
	 isLoadingGet: boolean = false;
	 message: string = MessageStatic.NotFound;

	ngOnDestroy() {
		this.subscriptions.unsubscribe();
	 }
	 downloadFile(fileUrl) {
		window.open(fileUrl, '_blank');
	   }
}