import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
  OnChanges,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { cloneDeep } from 'lodash-es';
import { finalize } from 'rxjs/operators';
import { CommonService } from '@services/common.service';
import { Address } from '@enums/address.enum';
import { MessageStatic } from '@enums/messageStatic.enum';
import { SwiftTransferGetModel } from '@models/orders/SwiftTransferGetModel';
import { Subscription } from 'rxjs';
import { ApplicationFeeGetModel } from '@models/orders/ApplicationFeeGetModel';
import { FreeOrderGetModel } from '@models/orders/freeOrderGetModel';
import { PerfectMoneyBuyingGetModel } from '@models/orders/perfectMoneyBuyingGetModel';
import { VoucherPerfectMoneyGetModel } from '@models/orders/VoucherPerfectMoneyGetModel';
import { VoucherPerfectMoneySellGetModel } from '@models/orders/VoucherPerfectMoneySellGetModel';
import { SendRemittanceToIranGetModel } from '@models/orders/SendRemittanceToIranGetModel';
import { WiseAccountChargeGetModel } from '@models/orders/WiseAccountChargeGetModel';
import { GiftCardGetModel } from '@models/orders/GiftCardGetModel';
import { PaymentInternationalSitesGetModel } from '@models/orders/PaymentInternationalSitesGetModel';
import { PayeerAccountRechargeGetModel } from '@models/orders/PayeerAccountRechargeGetModel';
import { BuyTradeServersGetModel } from '@models/orders/BuyTradeServersGetModel';
import { RenewalTradeServersGetModel } from '@models/orders/RenewalTradeServersGetModel';
import { BuyVirtualServersGetModel } from '@models/orders/BuyVirtualServersGetModel';
import { RenewalVirtualServersGetModel } from '@models/orders/RenewalVirtualServersGetModel';
import { SellingPerfectMoneyGetModel } from '@models/orders/sellingPerfectMoneyGetModel';
import { AppleGiftCardGetModel } from '@models/orders/appleGiftCardGetModel';
import { ApplicationFeeDetailSave } from 'src/app/core/params/order/ApplicationFeeDetailSaveModel';
import { ApplicationFeeDetailByIdModel } from 'src/app/core/params/order/AppliationFeeDetailById';
import { SellingWiseGetModel } from '@models/orders/sellingWiseGetModel';
import { PayeerSellingGetModel } from '@models/orders/PayeerSellingGetModel';
import { isGuid, stringIsEmptyOrNull } from '@helpers/validator.helper';
import { ValueTypeStore } from '@stores/getValueType.store';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { IncomeCashGetModel } from '@models/orders/incomeCashGetModel';
import { SurveyModel } from '@models/orders/surveyModel';

@Component({
  selector: 'orderDetails',
  templateUrl: 'orderDetails.component.html',
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderDetailsComponent implements OnInit, OnDestroy, OnChanges {
  constructor(
    private _commonService: CommonService,
    public ref: DynamicDialogRef,
    public config: DynamicDialogConfig,
    private cdr: ChangeDetectorRef,
    public _valueTypeStore: ValueTypeStore
  ) {}
  ngOnChanges() {}

  subscriptions = new Subscription();
  dataSwift: SwiftTransferGetModel;
  dataPerfectMoneyCharge: PerfectMoneyBuyingGetModel;
  dataPerfectMoneyVoucher: VoucherPerfectMoneyGetModel;
  dataSendRemittanceToIran: SendRemittanceToIranGetModel;
  dataFee: ApplicationFeeGetModel;
  dataFreeOrder: FreeOrderGetModel;
  dataWiseAccountCharge: WiseAccountChargeGetModel;
  dataGiftCard: GiftCardGetModel;
  dataPaymentInternationalSites: PaymentInternationalSitesGetModel;
  dataIncomeCash: IncomeCashGetModel;
  dataPayeerAccountRecharge: PayeerAccountRechargeGetModel;
  dataSellingPerfectMoney: SellingPerfectMoneyGetModel;
  dataPerfectMoneyVoucherSell: VoucherPerfectMoneySellGetModel;
  dataWiseSell: SellingWiseGetModel;
  dataPayeerSell: PayeerSellingGetModel;
  dataAppleGiftCard: AppleGiftCardGetModel;
  dataBuyTradeServer: BuyTradeServersGetModel;
  dataRenewalTradeServer: RenewalTradeServersGetModel;
  dataBuyVirtualServer: BuyVirtualServersGetModel;
  dataRenewalVirtualServer: RenewalVirtualServersGetModel;
  dataPaypalSellGet: any;
  dataPaypalByGet: any;
  dataPaypalRechargeGet: any;
  dataPermiumAccountsGet: any;
  timeout = null;
  isLoadingGet: boolean = false;
  message: string = MessageStatic.NotFound;
  @Input() orderTypeName: string;
  @Input() orderNumber: number;
  item: any;
  @Input() orderId: string;
  fileOrderId: string;
  applicationFeeDetailsData: ApplicationFeeDetailSave[] = [];
  multipleFeeById: ApplicationFeeDetailByIdModel;
  @Input() valueType: string;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  fileAdditional: IAdditionalFields[] = [];
  isShowOrderDetails: boolean = false;
  surveyData: SurveyModel = new SurveyModel();
  ngOnInit() {
    this.orderId = this.config.data.id;
    this.orderTypeName = this.config.data.orderTypeName;
    this.orderNumber = this.config.data.orderNumber;
    this.valueType = this.config.data.valueType;

    if (!stringIsEmptyOrNull(this.valueType)) {
      switch (this.valueType) {
        case 'GFC':
          this.getGiftCardById();
          break;
        case 'IWP':
          this.getPaymentInternationalSitesById();
          break;
        case 'PRM':
          this.getPremiumById();
          break;
        case 'PAC':
          this.getPaypalRechargeById();
          break;
        case 'PAS':
          this.getPaypalSellById();
          break;
        case 'APG':
          this.getApplicationFeeMultipleById();
          break;
        case 'PVS':
          this.getPerfectMoneyVoucherSellById();
          break;
        case 'PMS':
          this.getSellPerfectMoneyInfoById();
          break;
        case 'PVC':
          this.getPerfectMoneyVoucherById();
          break;
        case 'PMC':
          this.getPerfectMoneyChargeById();
          break;
        case 'WIC':
          this.getWiseAccountChargeById();
          break;
        case 'WIS':
          this.getSellingWiseById();
          break;
        case 'PYC':
          this.getPayeerAccountRechargeById();
          break;
        case 'PYS':
          this.getSellingPayeerById();
          break;
        case 'SWF':
          this.getSwiftTransferById();
          break;
        case 'TRI':
          this.getSendRemittanceToIranById();
          break;
        case 'FRE':
          this.getFreeOrderById();
          break;
        case 'ICX':
          this.getIncomeCashById();
          break;
      }
    } else {
      switch (Number(this.config.data.orderType)) {
        case 161:
          this.getSwiftTransferById();
          break;
        case 910:
          this.getPaypalRechargeById();
          break;
        case 171:
          this.getPaypalSellById();
          break;
        case 940:
          this.getPaypalSellById();
          break;
        case 162:
          this.getApplicationFeeById();
          break;
        case 175:
          this.getApplicationFeeById();
          break;
        case 177:
          this.getApplicationFeeById();
          break;
        case 163:
          this.getPerfectMoneyChargeById();
          break;
        case 164:
          this.getPerfectMoneyVoucherById();
          break;
        case 166:
          this.getPerfectMoneyVoucherSellById();
          break;
        case 165:
          this.getSellPerfectMoneyInfoById();
          break;
        case 167:
          this.getSendRemittanceToIranById();
          break;
        case 173:
          this.getWiseAccountChargeById();
          break;
        case 174:
          this.getGiftCardById();
          break;
        case 176:
          this.getPaymentInternationalSitesById();
          break;
        case 169:
          this.getPayeerAccountRechargeById();
          break;
        case 178:
          this.getBuyVirtualServerById();
          break;
        case 179:
          this.getRenewalVirtualServerById();
          break;
        case 900:
          this.getBuyTradeServerById();
          break;
        case 901:
          this.getRenewalTradeServerById();
          break;
        case 905:
          this.getApplicationFeeMultipleById();
          break;
        case 906:
          this.getSellingPayeerById();
          break;
        case 907:
          this.getSellingWiseById();
          break;
        case 959:
          this.getIncomeCashById();
          break;
        case 998:
          this.getFreeOrderById();
          break;
        case 999:
          this.getFreeOrderById();
          break;

        default:
          break;
      }
    }
  }

  public getPremiumById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderPermiumAcountGetAll, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPermiumAccountsGet = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataPermiumAccountsGet);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getPaypalSellById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PaypalSellGetAll, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPaypalSellGet = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataPaypalSellGet);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getPaypalRechargeById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PaypalRechargeGetAll, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPaypalRechargeGet = cloneDeep(res.data[0]);

            this.getAdditionalFields(this.dataPaypalRechargeGet);

            this.cdr.detectChanges();
          }
        })
    );
  }

  public getSwiftTransferById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.SwiftTransferGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataSwift = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataSwift);

            this.cdr.detectChanges();
          }
        })
    );
  }

  public getPerfectMoneyChargeById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PerfectMoneyBuyingGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPerfectMoneyCharge = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataPerfectMoneyCharge);

            this.cdr.detectChanges();
          }
        })
    );
  }

  public getSellPerfectMoneyInfoById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.SellingPerfectMoneyGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataSellingPerfectMoney = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataSellingPerfectMoney);

            this.cdr.detectChanges();
          }
        })
    );
  }

  public getPerfectMoneyVoucherById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.VoucherPerfectMoneyGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPerfectMoneyVoucher = cloneDeep(res.data[0]);

            this.cdr.detectChanges();
          }
        })
    );
  }

  public getPerfectMoneyVoucherSellById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.VoucherPerfectMoneySellGet, {
          orderId: this.config.data.id,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPerfectMoneyVoucherSell = cloneDeep(res.data[0]);

            this.getAdditionalFields(this.dataPerfectMoneyVoucherSell);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getSendRemittanceToIranById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.SendRemittanceToIranGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataSendRemittanceToIran = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataSendRemittanceToIran);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getWiseAccountChargeById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.WiseAccountChargeGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataWiseAccountCharge = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataWiseAccountCharge);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getSellingWiseById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderSellingWiseGetAll, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataWiseSell = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataWiseSell);

            this.cdr.detectChanges();
          }
        })
    );
  }

  public getGiftCardById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.GiftCardGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataGiftCard = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataGiftCard);

            this.cdr.detectChanges();
          }
        })
    );
  }

  public getPaymentInternationalSitesById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PaymentInternationalSitesGet, {
          orderId: this.config.data.id,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPaymentInternationalSites = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataPaymentInternationalSites);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getIncomeCashById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.IncomeCashGet, {
          orderId: this.config.data.id,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataIncomeCash = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataIncomeCash);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getPayeerAccountRechargeById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.PayeerAccountRechargeGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPayeerAccountRecharge = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataPayeerAccountRecharge);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getSellingPayeerById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.SellingPayeerGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataPayeerSell = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataPayeerSell);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getApplicationFeeById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.ApplicationFeeGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataFee = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataFee);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getFreeOrderById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.FreeOrderGetAll, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataFreeOrder = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataFreeOrder);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getApplicationFeeMultipleDetails(applicationFeeMultipleId: string) {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.ApplicationFeeGroupDetailsGet, {
          applicationFeeMultipleId: applicationFeeMultipleId,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.applicationFeeDetailsData = cloneDeep(res.data);

            this.multipleFeeById.multipleDetails =
              this.applicationFeeDetailsData;

            this.cdr.detectChanges();
          }
        })
    );
  }
  public getApplicationFeeMultipleById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.ApplicationFeeGroupGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.multipleFeeById = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.multipleFeeById);
            this.getApplicationFeeMultipleDetails(
              this.multipleFeeById.applicationFeeMultipleId
            );

            this.cdr.detectChanges();
          }
        })
    );
  }

  public getAppleGiftCardById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.GiftCardGet, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataAppleGiftCard = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataAppleGiftCard);
            this.cdr.detectChanges();
          }
        })
    );
  }
  public getBuyVirtualServerById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.VirtualServersGetAll, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataBuyVirtualServer = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataBuyVirtualServer);
            this.cdr.detectChanges();
          }
        })
    );
  }

  public getRenewalVirtualServerById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.VirtualServersGetAll, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataRenewalVirtualServer = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataRenewalVirtualServer);
            this.cdr.detectChanges();
          }
        })
    );
  }
  public getBuyTradeServerById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.VirtualServersGetAll, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataBuyTradeServer = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataBuyTradeServer);
            this.cdr.detectChanges();
          }
        })
    );
  }
  public getRenewalTradeServerById() {
    this.isLoadingGet = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.VirtualServersGetAll, { orderId: this.config.data.id })
        .pipe(
          finalize(() => {
            this.isLoadingGet = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res) {
            this.dataRenewalTradeServer = cloneDeep(res.data[0]);
            this.getAdditionalFields(this.dataRenewalTradeServer);
            this.cdr.detectChanges();
          }
        })
    );
  }

  close() {
    this.ref.close(this.isShowOrderDetails);
    this.cdr.detectChanges();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
  loadFiles(item: any) {
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + item.value)
        .pipe(
          finalize(() => {
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            item.url = response;

            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  getAdditionalFields(data) {
    this.fileOrderId = data.fileOrderId;
    this.valueType = data.valueType;

    this.item = data;
    if (data.additionalValues) {
      data.additionalValues = JSON.parse(data.additionalValues);

      for (let item of data.additionalValues) {
        if (!stringIsEmptyOrNull(item.value) && isGuid(item.value)) {
          this.loadFiles(item);
        }
      }
    }
  }
}
