import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
} from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { scrollTop } from '@helpers/window.helper';
import { StyleStore } from '@stores/style.store';
import { Subscription } from 'rxjs';
import { fadeAnimation } from 'src/app/core/animations/animations';

@Component({
  selector: 'orders',
  templateUrl: './orders.component.html',
  styleUrls: ['./orders.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class OrdersComponent implements OnInit, OnDestroy, AfterViewInit {
  subscriptions = new Subscription();
  constructor(
    private _styleStore: StyleStore,
    private _activatedroute: ActivatedRoute,
    private _router: Router
  ) {}

  ngOnInit(): void {
    if (!stringIsEmptyOrNull(this._activatedroute.snapshot.params['language']))
      this._router.navigateByUrl(
        '/dashboard/orders/invoices/' +
          this._activatedroute.snapshot.params['language']
      );

    this._styleStore.layoutWith.next({
      width: 'w-full',
      isDashFooter: false,
    });
  }
  ngAfterViewInit() {}
  onActivate(event) {
    scrollTop();
  }

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
}
