import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { OrdersComponent } from './orders.component';
const routes: Routes = [
  {
    path: '',
    component: OrdersComponent,
    children: [
      { path: '', pathMatch: 'full', redirectTo: 'invoices' },
      { path: ':/language', pathMatch: 'full', redirectTo: 'invoices/en' },
      {
        path: 'invoices',
        data: {
          title: 'سفارش های من',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./orderList/orderList.module').then((m) => m.OrderListModule),
      },
      {
        path: 'invoices/:language',
        data: {
          title: 'سفارش های من',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./orderList/orderList.module').then((m) => m.OrderListModule),
      },

      {
        path: 'depositDocument/:type/:id',
        data: {
          title: 'ارسال فیش واریزی',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./depositDocument/depositDocument.module').then(
            (m) => m.DepositDocumentModule
          ),
      },
      
      {
        path: 'depositDocument/:type/:id/:language',
        data: {
          title: 'ارسال فیش واریزی',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./depositDocument/depositDocument.module').then(
            (m) => m.DepositDocumentModule
          ),
      },
      {
        path: 'transactions/:id',
        data: {
          title: 'تاریخچه ی تراکنش ها',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./transactions/transactions.module').then(
            (m) => m.TransactionsModule
          ),
      },
      {
        path: 'transactions/:id/:language',
        data: {
          title: 'تاریخچه ی تراکنش ها',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./transactions/transactions.module').then(
            (m) => m.TransactionsModule
          ),
      },
      {
        path: 'payment-crypto/:id',
        data: {
          title: 'انتخاب رمز ارز',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./paymentWithCryptoCurrency/paymentWithCryptoCurrency.module').then(
            (m) => m.PaymentWithCryptoCurrencyModule
          ),
      },
      {
        path: 'payment-crypto/:id/:language',
        data: {
          title: 'انتخاب رمز ارز',
          breadcrumb: [
            { title: 'سفارش های من', url: '/dashboard/orders/invoices' },
          ],
        },
        loadChildren: () =>
          import('./paymentWithCryptoCurrency/paymentWithCryptoCurrency.module').then(
            (m) => m.PaymentWithCryptoCurrencyModule
          ),
      },

      {
        path: 'wallet-crypto/:id',
        data: {
          title: 'اطلاعات واریز رمز ارز',
          breadcrumb: [
            { title: 'انتخاب رمز ارز', url: '/dashboard/orders/payment-crypto' },
          ],
        },
        loadChildren: () =>
          import('./walletCryptoCurrency/walletCryptoCurrency.module').then(
            (m) => m.WalletCryptoCurrencyModule
          ),
      },
      {
        path: 'wallet-crypto/:id/:language',
        data: {
          title: 'اطلاعات واریز رمز ارز',
          breadcrumb: [
            { title: 'انتخاب رمز ارز', url: '/dashboard/orders/payment-crypto' },
          ],
        },
        loadChildren: () =>
          import('./walletCryptoCurrency/walletCryptoCurrency.module').then(
            (m) => m.WalletCryptoCurrencyModule
          ),
      },
      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class OrdersRoutingModule { }
