import {
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { Address } from '@enums/address.enum';
import { MessageStatic } from '@enums/messageStatic.enum';
import { Transaction } from '@interfaces/orders/iTransactions';
import { CommonService } from '@services/common.service';
import { Location } from '@angular/common';
import { cloneDeep } from 'lodash-es';
import { LazyLoadEvent, Message } from 'primeng/api';
import { Subscription, finalize } from 'rxjs';
import { OrderSearchModel } from 'src/app/core/params/order/OrderSearchModel';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { OrderListModel } from '@models/orders/OrderListModel';
import { fadeAnimation } from 'src/app/core/animations/animations';

@Component({
  selector: 'app-transaction-list',
  templateUrl: './transactions.component.html',
  styleUrls: ['./transactions.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class TransactionComponent implements OnInit, OnDestroy, AfterViewInit {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    public _activatedroute: ActivatedRoute,
    public location: Location,
  ) {}

  subscriptions = new Subscription();
  messages: Message[] = [];
  data: Transaction[] = [];
  filter: any = {};
  order: OrderListModel = new OrderListModel();
  isLoading: boolean = false;
  query: BaseParams;
  totalRecords: number = 0;
  search: OrderSearchModel = new OrderSearchModel();
  message: string = MessageStatic.NotFound;

  ngAfterViewInit(): void {}

  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
  }

  ngOnInit(): void {
    this.query = new BaseParams();
    Object.assign(this.query, this.search);
    this.getData();
    this.getOrderById();
  }

  goBackToPrevPage() {
    this.location.back();
  }

  getOrderById(event: LazyLoadEvent = null): void {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.OrderGetbyId, {
          orderId: this._activatedroute.snapshot.params['id'],
        })
        .pipe(
          finalize(() => {
            this.isLoading = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            this.order = cloneDeep(res.data);

            this.cdr.detectChanges();
          }
        })
    );
  }

  getData(event: LazyLoadEvent = null): void {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.query = new BaseParams();
    this.query.pageSize = 100;
    this.subscriptions.add(
      this._commonService
        .put(Address.TransActionGetAll, {
          orderId: this._activatedroute.snapshot.params['id'],
        })
        .pipe(
          finalize(() => {
            this.isLoading = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            let transactionsData = cloneDeep(res.data);
            this.data = transactionsData
            this.totalRecords = this.data.length;
            this.cdr.detectChanges();
          }
        })
    );
  }
}
