import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ChargeAccountComponent } from './chargeAccount.component';
const routes: Routes = [
  {
    path: '',

    component: ChargeAccountComponent,
    data: {
      breadcrumb: [
        {
          title: 'شارژ حساب',
          url: '/dashboard/Cat/internationalPayment',
        },
      ],
    },
    children: [
      {
        data: { title: 'شارژ حساب' },
        path: ':orderType',
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderChargeAccountModule
          ),
      },
      {
        data: {  title: 'شارژ حساب', },
        path: ':orderType/:language',
        loadChildren: () =>
          import('./order/order.module').then(
            (m) => m.OrderChargeAccountModule
          ),
      },

      { path: '**', redirectTo: 'errors' },
    ],
  },
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule],
})
export class ChargeAccountRoutingModule {}
