import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import {
  Component,
  OnDestroy,
  OnInit,
  AfterViewInit,
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  HostListener,
  ElementRef,
  ViewChild,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { UserProfile } from '@interfaces/user/userProfile';
import { CommonService } from '@services/common.service';
import { finalize, Subscription } from 'rxjs';
import { response } from '@interfaces/response';
import { PaymentInternationalSitesPriceModel } from '@models/orders/PaymentInternationalSitesPriceModel';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { PaymentInternationalSitesSaveModel } from 'src/app/core/params/order/PaymentInternationalSitesSaveModel';
import { CurrencyModel } from '@models/orders/CurrencyModel';
import { FileUploadService } from '@services/fileUpload.service';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';
import { DeviceDetectorService } from 'ngx-device-detector';
import { LegalOrderComponent } from '../../components/legal-order/legal-order.component';
import { IStatic } from '@interfaces/dbo/iStatic';
import { MenuItem } from 'primeng/api';
import { IExistVerifying } from '@interfaces/user/IExistVerifying';
import { IAdditionalFields } from '@interfaces/orders/iAdditionalFields';
import { IQuestionList } from '@interfaces/dbo/IQuestionList';
import { DialogService } from 'primeng/dynamicdialog';
import { OrderVerifyComponent } from 'src/app/modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { OrderTypeStore } from '@stores/getOrderType.store';
import { TranslateService } from '@ngx-translate/core';

@Component({
  selector: 'app-paymentinternationalsites-order',
  templateUrl: './order.component.html',
  styleUrls: ['./order.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class OrderChargeAccountComponent
  implements OnInit, OnDestroy, AfterViewInit
{
  subscriptions = new Subscription();
  isLoadingGet: boolean = false;
  isValidLegalForm: boolean = true;
  isLoadingGetCountry: boolean = false;
  isLoadingGetFullOrder: boolean = false;
  isLoadingGetPrice: boolean = false;
  isLoadingGetVerify: boolean = false;
  inquiryIsOk: boolean = false;
  dataCurrency: CurrencyModel[] = [];
  selectedCurrency: CurrencyModel;
  isShowOrder: boolean = true;
  data: UserProfile;
  totalQuestionRecord: number = 0;
  timeout = null;
  fixedEffectiveAmount: number;
  staticData: IStatic;
  isDesktop: boolean;
  dataPrice: PaymentInternationalSitesPriceModel;
  model: PaymentInternationalSitesSaveModel =
    new PaymentInternationalSitesSaveModel();
  isLoading: boolean = false;
  isLoadingFile: boolean = false;
  isLoadingGetFile: boolean = false;
  extensionStore: string;
  canNotUpload: boolean = false;
  url: string = null;
  file: File;
  progress: number = 0;
  orderType: string;
  keyValues: string;
  notificationBeforeSave: string;
  notificationBeforeSaveType: string;
  dataSteps: MenuItem[] = [];
  additionalFiels: IAdditionalFields[] = [];
  dataQuestion: IQuestionList[] = [];
  dataSetting: IExistVerifying;
  dataStatic: any;
  displayModal: boolean = false;
  totalRecord: number = 0;
  imageId: string;
  isVerifiedInfo: boolean = false;
  dataUser: UserProfile;
  errMsg: any;

  @ViewChild('amountInput') amountInputRef!: ElementRef;
  @ViewChild(LegalOrderComponent) appChildComponent: LegalOrderComponent;
  @ViewChild('orderVerify') orderVerify: OrderVerifyComponent;
  constructor(
    private _alert: AlertHelper,
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _router: Router,
    private _fileUploadService: FileUploadService,
    public _deviceDetectorService: DeviceDetectorService,
    private _activatedRoute: ActivatedRoute,
    private _translateService: TranslateService,
    public dialogService: DialogService,
    public _orderTypeStore: OrderTypeStore
  ) {
    this._router.events.subscribe((event) => {
      if (event instanceof NavigationStart) {
        if (
          event.url.split('/')[4] != undefined &&
          event.url.split('/')[4] != null &&
          event.url.split('/')[4] != ''
        ) {
          this.imageId = null;
          this.handleChangeRoute(event.url.split('/')[4]);
        }
      }
    });
  }

  ngOnInit(): void {
    this.isDesktop = this._deviceDetectorService.isDesktop();
    this.handleChangeRoute(this._activatedRoute.snapshot.params['orderType']);
  }

  ngAfterViewInit() {}

  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  getKeyValuesAdditional(keyValue) {
    this.model.additionalValues = keyValue;
  }

  fileChange(event) {
    let fileList: FileList =
      event.target != undefined && event.target != null
        ? event.target.files
        : event;
    if (fileList.length > 0) {
      this.file = fileList[0];
      this.fileUpload();
    }
  }

  fileUpload() {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._fileUploadService
        .fileUpload(this.file.name, this.file, Address.FileUploadBig)
        .subscribe((event: HttpEvent<any>) => {
          switch (event.type) {
            case HttpEventType.Sent:
              break;
            case HttpEventType.ResponseHeader:
              break;
            case HttpEventType.UploadProgress:
              var eventTotal = event.total ? event.total : 0;
              this.progress = Math.round((event.loaded / eventTotal) * 100);
              this.cdr.detectChanges();
              break;
            case HttpEventType.Response:
              if (event.body['data'] != null) {
                this.model.fileId = event.body['data'];
                this.loadFiles(event.body['data']);
                this.isLoadingFile = false;
                this.cdr.detectChanges();
              }
              setTimeout(() => {
                this.progress = 0;
                this.cdr.detectChanges();
              }, 1500);
          }
        })
    );
  }

  loadFiles(id: string) {
    this.isLoadingGetFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.isLoadingGetFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.url = response;
            this.extensionStore = String(
              this.url.substring(this.url.lastIndexOf('.') + 1, this.url.length)
            ).toLowerCase();
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }
  remove() {
    this.url = null;
    this.cdr.detectChanges();
  }

  handleChangeRoute(e: string) {
    setTimeout(() => {
      this.clearAmountInput();
    });
    this.orderType = e;
    if (!stringIsEmptyOrNull(this.orderType)) {
      this.getStaticById();
    }
  }

  private clearAmountInput(): void {
    this.model.amount = null;
    this.fixedEffectiveAmount = null;

    if (this.amountInputRef?.nativeElement) {
      this.amountInputRef.nativeElement.value = '';
    }
  }

  getFullOrder() {
    this.isLoadingGetFullOrder = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(
          Address.OrderGetFullPage,
          {
            isArchive: false,
            orderType: Number(this.orderType),
            sort: 'sortNumber asc',
            pageSize: 50,
            moduleType: 30001,
          },
          false
        )
        .pipe(
          finalize(() => {
            this.isLoadingGetFullOrder = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            if (response.data.currency && response.data.currency.data)
              this.dataCurrency = response.data.currency.data;

            if (this.dataCurrency && this.dataCurrency.length > 0) {
              this.selectedCurrency = this.dataCurrency[0];
            }

            if (response.data.steps && response.data.steps.data) {
              this.dataSteps = response.data.steps.data;
            }
            if (this.dataCurrency && this.dataCurrency.length == 1) {
              this.selectedCurrency = this.dataCurrency[0];
            }
            if (response.data.setting && response.data.setting.data) {
              this.dataSetting = response.data.setting.data;
            }

            if (
              response.data.question.data &&
              response.data.question.data.length > 0
            ) {
              this.dataQuestion = response.data.question.data;
              this.totalRecord = this.dataQuestion.length;
            }

            if (response.data.static.data) {
              this.dataStatic = response.data.static.data;

              if (this.dataStatic.additionalFields) {
                this.additionalFiels = JSON.parse(
                  this.dataStatic.additionalFields
                );
              }
              if (
                this.dataStatic.imageId &&
                (this.dataStatic.imageId != null ||
                  this.dataStatic.imageId != '')
              ) {
                this.imageId = this.dataStatic.imageId;
              }
            }
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getPrice() {
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.orderType = this.orderType;
    this.subscriptions.add(
      this._commonService
        .put(Address.PaymentInternationalSitesGetPrice, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoadingGetPrice = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataPrice = response.data;
            this.inquiryIsOk = true;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  getStaticById() {
    this.subscriptions.add(
      this._commonService
        .put(Address.GetStaticById, {
          staticId: Number(this.orderType),
        })
        .pipe(
          finalize(() => {
            this.getFullOrder();
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.staticData = response.data;
            this.fixedEffectiveAmount = this.staticData.fixedEffectiveAmount;

            if (this.staticData.imageId)
              this.loadFilesStaticImage(this.staticData.imageId);
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  loadFilesStaticImage(id: string) {
    this.isLoadingFile = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoadingFile = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.staticData.fileUrl = response;

            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  inquiry() {
    clearTimeout(this.timeout);
    if (
      this.selectedCurrency &&
      !isNaN(Number(this.model.amount)) &&
      Number(this.model.amount) > 0
    ) {
      this.isLoadingGetPrice = true;
      this.cdr.detectChanges();
      this.timeout = setTimeout(() => {
        this.getPrice();
      }, 900);
    } else {
      this.isLoadingGetPrice = false;
      this.dataPrice = null;
      this.cdr.detectChanges();
    }
  }

  additionalFieldsValid(): boolean {
    if (!this.additionalFiels.length) return true;

    let isValid = true;

    this.additionalFiels.forEach((field) => {
      if (
        !field.isDeleted &&
        (field.persianName?.trim() || field.englishName?.trim()) &&
        field.required === true &&
        (!field.value || String(field.value).trim() === '')
      ) {
        isValid = false;
      }
    });

    return isValid;
  }

  submit() {
    if (!this.additionalFieldsValid()) {
      this._alert.error('لطفا از پر کردن تمام بخش‌های ستاره دار مطمئن شوید.');
      return;
    }
    if (!this.isValidLegalForm) {
      this._alert.warning('لطفا قسمت های اجباری فرم حقوقی را تکمیل نمایید');
      return;
    }

    this.isLoading = true;
    this.model.currencyId = this.selectedCurrency.currencyId;
    this.model.orderType = this.orderType;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.FreeOrdersSave, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this._orderTypeStore.orderTypeBehavior.next(this.model.orderType);
            this._alert.success(
              this._translateService.translations[
                this._translateService.currentLang
              ]['checkoutSubmittedSuccesfully']
            );
            this._router.navigateByUrl(
              '/dashboard/checkouts/freeorder/' + response.data.orderId
            );
          },
          (error) => {
            this.errMsg = error.status;
            if ([473, 472, 475, 474, 470, 471, 476].includes(error.status)) {
              setTimeout(() => {
                this.orderVerify.modalGetMobile();
              }, 200);
            }
          }
        )
    );
  }

  isSideFix: boolean = false;
  @HostListener('window:scroll', ['$event'])
  onWindowScroll($event) {
    const numberHeigth = window.scrollY;
    if (numberHeigth >= 90) {
      this.isSideFix = true;
    } else {
      this.isSideFix = false;
    }
  }

  onDialogHide() {
    this.displayModal = false;
  }
}
