import {
  Component,
  ElementRef,
  EventEmitter,
  Input,
  Output,
  ViewChild,
} from '@angular/core';

@Component({
  selector: 'app-order-side-box',
  templateUrl: './orderSideBox.component.html',
})
export class OrderSideBoxComponent {
  @Input() imageId!: string | null;
  @Input() isLoadingGetPrice: boolean = false;
  @Input() isLoading: boolean = false;
  @Input() isAmazonOrder: boolean = false;
  @Input() inquiryIsOk: boolean = false;
  @Input() selectedCurrency: any;
  @Input() model: any;
  @Input() dataPrice: any;
  @Input() dataSetting: { orderDescription?: string } | null = null;

  @Output() submitOrder = new EventEmitter<void>();

  @ViewChild('priceButton') priceButton!: ElementRef<HTMLDivElement>;

  submit() {
    this.submitOrder.emit();
  }
}
